package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ReplaceDefaultPolicyVersionParams(
    templateName: zio.aws.iot.model.PolicyTemplateName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ReplaceDefaultPolicyVersionParams = {
    import ReplaceDefaultPolicyVersionParams.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ReplaceDefaultPolicyVersionParams
      .builder()
      .templateName(templateName.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ReplaceDefaultPolicyVersionParams.ReadOnly =
    zio.aws.iot.model.ReplaceDefaultPolicyVersionParams.wrap(buildAwsValue())
}
object ReplaceDefaultPolicyVersionParams {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ReplaceDefaultPolicyVersionParams
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ReplaceDefaultPolicyVersionParams =
      zio.aws.iot.model.ReplaceDefaultPolicyVersionParams(templateName)
    def templateName: zio.aws.iot.model.PolicyTemplateName
    def getTemplateName
        : ZIO[Any, Nothing, zio.aws.iot.model.PolicyTemplateName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ReplaceDefaultPolicyVersionParams
  ) extends zio.aws.iot.model.ReplaceDefaultPolicyVersionParams.ReadOnly {
    override val templateName: zio.aws.iot.model.PolicyTemplateName =
      zio.aws.iot.model.PolicyTemplateName.wrap(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ReplaceDefaultPolicyVersionParams
  ): zio.aws.iot.model.ReplaceDefaultPolicyVersionParams.ReadOnly = new Wrapper(
    impl
  )
}
