package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.StringDateTime
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SchedulingConfig(
    startTime: Optional[StringDateTime] = Optional.Absent,
    endTime: Optional[StringDateTime] = Optional.Absent,
    endBehavior: Optional[zio.aws.iot.model.JobEndBehavior] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.SchedulingConfig = {
    import SchedulingConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SchedulingConfig
      .builder()
      .optionallyWith(
        startTime.map(value => StringDateTime.unwrap(value): java.lang.String)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => StringDateTime.unwrap(value): java.lang.String)
      )(_.endTime)
      .optionallyWith(endBehavior.map(value => value.unwrap))(_.endBehavior)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SchedulingConfig.ReadOnly =
    zio.aws.iot.model.SchedulingConfig.wrap(buildAwsValue())
}
object SchedulingConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.SchedulingConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SchedulingConfig =
      zio.aws.iot.model.SchedulingConfig(
        startTime.map(value => value),
        endTime.map(value => value),
        endBehavior.map(value => value)
      )
    def startTime: Optional[StringDateTime]
    def endTime: Optional[StringDateTime]
    def endBehavior: Optional[zio.aws.iot.model.JobEndBehavior]
    def getStartTime: ZIO[Any, AwsError, StringDateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, StringDateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getEndBehavior: ZIO[Any, AwsError, zio.aws.iot.model.JobEndBehavior] =
      AwsError.unwrapOptionField("endBehavior", endBehavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SchedulingConfig
  ) extends zio.aws.iot.model.SchedulingConfig.ReadOnly {
    override val startTime: Optional[StringDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.iot.model.primitives.StringDateTime(value))
    override val endTime: Optional[StringDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.iot.model.primitives.StringDateTime(value))
    override val endBehavior: Optional[zio.aws.iot.model.JobEndBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endBehavior())
        .map(value => zio.aws.iot.model.JobEndBehavior.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SchedulingConfig
  ): zio.aws.iot.model.SchedulingConfig.ReadOnly = new Wrapper(impl)
}
