package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.MitigationActionsTaskId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartAuditMitigationActionsTaskResponse(
    taskId: Optional[MitigationActionsTaskId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskResponse = {
    import StartAuditMitigationActionsTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskResponse
      .builder()
      .optionallyWith(
        taskId.map(value =>
          MitigationActionsTaskId.unwrap(value): java.lang.String
        )
      )(_.taskId)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.StartAuditMitigationActionsTaskResponse.ReadOnly =
    zio.aws.iot.model.StartAuditMitigationActionsTaskResponse
      .wrap(buildAwsValue())
}
object StartAuditMitigationActionsTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StartAuditMitigationActionsTaskResponse =
      zio.aws.iot.model
        .StartAuditMitigationActionsTaskResponse(taskId.map(value => value))
    def taskId: Optional[MitigationActionsTaskId]
    def getTaskId: ZIO[Any, AwsError, MitigationActionsTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskResponse
  ) extends zio.aws.iot.model.StartAuditMitigationActionsTaskResponse.ReadOnly {
    override val taskId: Optional[MitigationActionsTaskId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskId())
        .map(value =>
          zio.aws.iot.model.primitives.MitigationActionsTaskId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskResponse
  ): zio.aws.iot.model.StartAuditMitigationActionsTaskResponse.ReadOnly =
    new Wrapper(impl)
}
