package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ThingIndexingConfiguration(
    thingIndexingMode: zio.aws.iot.model.ThingIndexingMode,
    thingConnectivityIndexingMode: Optional[
      zio.aws.iot.model.ThingConnectivityIndexingMode
    ] = Optional.Absent,
    deviceDefenderIndexingMode: Optional[
      zio.aws.iot.model.DeviceDefenderIndexingMode
    ] = Optional.Absent,
    namedShadowIndexingMode: Optional[
      zio.aws.iot.model.NamedShadowIndexingMode
    ] = Optional.Absent,
    managedFields: Optional[Iterable[zio.aws.iot.model.Field]] =
      Optional.Absent,
    customFields: Optional[Iterable[zio.aws.iot.model.Field]] = Optional.Absent,
    filter: Optional[zio.aws.iot.model.IndexingFilter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ThingIndexingConfiguration = {
    import ThingIndexingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ThingIndexingConfiguration
      .builder()
      .thingIndexingMode(thingIndexingMode.unwrap)
      .optionallyWith(thingConnectivityIndexingMode.map(value => value.unwrap))(
        _.thingConnectivityIndexingMode
      )
      .optionallyWith(deviceDefenderIndexingMode.map(value => value.unwrap))(
        _.deviceDefenderIndexingMode
      )
      .optionallyWith(namedShadowIndexingMode.map(value => value.unwrap))(
        _.namedShadowIndexingMode
      )
      .optionallyWith(
        managedFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedFields)
      .optionallyWith(
        customFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customFields)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ThingIndexingConfiguration.ReadOnly =
    zio.aws.iot.model.ThingIndexingConfiguration.wrap(buildAwsValue())
}
object ThingIndexingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ThingIndexingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ThingIndexingConfiguration =
      zio.aws.iot.model.ThingIndexingConfiguration(
        thingIndexingMode,
        thingConnectivityIndexingMode.map(value => value),
        deviceDefenderIndexingMode.map(value => value),
        namedShadowIndexingMode.map(value => value),
        managedFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filter.map(value => value.asEditable)
      )
    def thingIndexingMode: zio.aws.iot.model.ThingIndexingMode
    def thingConnectivityIndexingMode
        : Optional[zio.aws.iot.model.ThingConnectivityIndexingMode]
    def deviceDefenderIndexingMode
        : Optional[zio.aws.iot.model.DeviceDefenderIndexingMode]
    def namedShadowIndexingMode
        : Optional[zio.aws.iot.model.NamedShadowIndexingMode]
    def managedFields: Optional[List[zio.aws.iot.model.Field.ReadOnly]]
    def customFields: Optional[List[zio.aws.iot.model.Field.ReadOnly]]
    def filter: Optional[zio.aws.iot.model.IndexingFilter.ReadOnly]
    def getThingIndexingMode
        : ZIO[Any, Nothing, zio.aws.iot.model.ThingIndexingMode] =
      ZIO.succeed(thingIndexingMode)
    def getThingConnectivityIndexingMode
        : ZIO[Any, AwsError, zio.aws.iot.model.ThingConnectivityIndexingMode] =
      AwsError.unwrapOptionField(
        "thingConnectivityIndexingMode",
        thingConnectivityIndexingMode
      )
    def getDeviceDefenderIndexingMode
        : ZIO[Any, AwsError, zio.aws.iot.model.DeviceDefenderIndexingMode] =
      AwsError.unwrapOptionField(
        "deviceDefenderIndexingMode",
        deviceDefenderIndexingMode
      )
    def getNamedShadowIndexingMode
        : ZIO[Any, AwsError, zio.aws.iot.model.NamedShadowIndexingMode] =
      AwsError.unwrapOptionField(
        "namedShadowIndexingMode",
        namedShadowIndexingMode
      )
    def getManagedFields
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Field.ReadOnly]] =
      AwsError.unwrapOptionField("managedFields", managedFields)
    def getCustomFields
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Field.ReadOnly]] =
      AwsError.unwrapOptionField("customFields", customFields)
    def getFilter
        : ZIO[Any, AwsError, zio.aws.iot.model.IndexingFilter.ReadOnly] =
      AwsError.unwrapOptionField("filter", filter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ThingIndexingConfiguration
  ) extends zio.aws.iot.model.ThingIndexingConfiguration.ReadOnly {
    override val thingIndexingMode: zio.aws.iot.model.ThingIndexingMode =
      zio.aws.iot.model.ThingIndexingMode.wrap(impl.thingIndexingMode())
    override val thingConnectivityIndexingMode
        : Optional[zio.aws.iot.model.ThingConnectivityIndexingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingConnectivityIndexingMode())
        .map(value =>
          zio.aws.iot.model.ThingConnectivityIndexingMode.wrap(value)
        )
    override val deviceDefenderIndexingMode
        : Optional[zio.aws.iot.model.DeviceDefenderIndexingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceDefenderIndexingMode())
        .map(value => zio.aws.iot.model.DeviceDefenderIndexingMode.wrap(value))
    override val namedShadowIndexingMode
        : Optional[zio.aws.iot.model.NamedShadowIndexingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namedShadowIndexingMode())
        .map(value => zio.aws.iot.model.NamedShadowIndexingMode.wrap(value))
    override val managedFields
        : Optional[List[zio.aws.iot.model.Field.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Field.wrap(item)
          }.toList
        )
    override val customFields
        : Optional[List[zio.aws.iot.model.Field.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Field.wrap(item)
          }.toList
        )
    override val filter: Optional[zio.aws.iot.model.IndexingFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filter())
        .map(value => zio.aws.iot.model.IndexingFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ThingIndexingConfiguration
  ): zio.aws.iot.model.ThingIndexingConfiguration.ReadOnly = new Wrapper(impl)
}
