package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  RemoveAuthorizerConfig,
  ReservedDomainConfigurationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDomainConfigurationRequest(
    domainConfigurationName: ReservedDomainConfigurationName,
    authorizerConfig: Optional[zio.aws.iot.model.AuthorizerConfig] =
      Optional.Absent,
    domainConfigurationStatus: Optional[
      zio.aws.iot.model.DomainConfigurationStatus
    ] = Optional.Absent,
    removeAuthorizerConfig: Optional[RemoveAuthorizerConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest = {
    import UpdateDomainConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest
      .builder()
      .domainConfigurationName(
        ReservedDomainConfigurationName.unwrap(
          domainConfigurationName
        ): java.lang.String
      )
      .optionallyWith(authorizerConfig.map(value => value.buildAwsValue()))(
        _.authorizerConfig
      )
      .optionallyWith(domainConfigurationStatus.map(value => value.unwrap))(
        _.domainConfigurationStatus
      )
      .optionallyWith(
        removeAuthorizerConfig.map(value =>
          RemoveAuthorizerConfig.unwrap(value): java.lang.Boolean
        )
      )(_.removeAuthorizerConfig)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UpdateDomainConfigurationRequest.ReadOnly =
    zio.aws.iot.model.UpdateDomainConfigurationRequest.wrap(buildAwsValue())
}
object UpdateDomainConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateDomainConfigurationRequest =
      zio.aws.iot.model.UpdateDomainConfigurationRequest(
        domainConfigurationName,
        authorizerConfig.map(value => value.asEditable),
        domainConfigurationStatus.map(value => value),
        removeAuthorizerConfig.map(value => value)
      )
    def domainConfigurationName: ReservedDomainConfigurationName
    def authorizerConfig: Optional[zio.aws.iot.model.AuthorizerConfig.ReadOnly]
    def domainConfigurationStatus
        : Optional[zio.aws.iot.model.DomainConfigurationStatus]
    def removeAuthorizerConfig: Optional[RemoveAuthorizerConfig]
    def getDomainConfigurationName
        : ZIO[Any, Nothing, ReservedDomainConfigurationName] =
      ZIO.succeed(domainConfigurationName)
    def getAuthorizerConfig
        : ZIO[Any, AwsError, zio.aws.iot.model.AuthorizerConfig.ReadOnly] =
      AwsError.unwrapOptionField("authorizerConfig", authorizerConfig)
    def getDomainConfigurationStatus
        : ZIO[Any, AwsError, zio.aws.iot.model.DomainConfigurationStatus] =
      AwsError.unwrapOptionField(
        "domainConfigurationStatus",
        domainConfigurationStatus
      )
    def getRemoveAuthorizerConfig: ZIO[Any, AwsError, RemoveAuthorizerConfig] =
      AwsError.unwrapOptionField(
        "removeAuthorizerConfig",
        removeAuthorizerConfig
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest
  ) extends zio.aws.iot.model.UpdateDomainConfigurationRequest.ReadOnly {
    override val domainConfigurationName: ReservedDomainConfigurationName =
      zio.aws.iot.model.primitives
        .ReservedDomainConfigurationName(impl.domainConfigurationName())
    override val authorizerConfig
        : Optional[zio.aws.iot.model.AuthorizerConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizerConfig())
        .map(value => zio.aws.iot.model.AuthorizerConfig.wrap(value))
    override val domainConfigurationStatus
        : Optional[zio.aws.iot.model.DomainConfigurationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainConfigurationStatus())
        .map(value => zio.aws.iot.model.DomainConfigurationStatus.wrap(value))
    override val removeAuthorizerConfig: Optional[RemoveAuthorizerConfig] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeAuthorizerConfig())
        .map(value =>
          zio.aws.iot.model.primitives.RemoveAuthorizerConfig(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest
  ): zio.aws.iot.model.UpdateDomainConfigurationRequest.ReadOnly = new Wrapper(
    impl
  )
}
