package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{UserPropertyValue, UserPropertyKey}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UserProperty(key: UserPropertyKey, value: UserPropertyValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UserProperty = {
    import UserProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UserProperty
      .builder()
      .key(UserPropertyKey.unwrap(key): java.lang.String)
      .value(UserPropertyValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.UserProperty.ReadOnly =
    zio.aws.iot.model.UserProperty.wrap(buildAwsValue())
}
object UserProperty {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.UserProperty] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UserProperty =
      zio.aws.iot.model.UserProperty(key, value)
    def key: UserPropertyKey
    def value: UserPropertyValue
    def getKey: ZIO[Any, Nothing, UserPropertyKey] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, UserPropertyValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UserProperty
  ) extends zio.aws.iot.model.UserProperty.ReadOnly {
    override val key: UserPropertyKey =
      zio.aws.iot.model.primitives.UserPropertyKey(impl.key())
    override val value: UserPropertyValue =
      zio.aws.iot.model.primitives.UserPropertyValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UserProperty
  ): zio.aws.iot.model.UserProperty.ReadOnly = new Wrapper(impl)
}
