package zio.aws.iotfleetwise
import zio.aws.iotfleetwise.model.UpdateSignalCatalogResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.iotfleetwise.model.{
  ImportSignalCatalogRequest,
  ListVehiclesInFleetRequest,
  CreateDecoderManifestRequest,
  ListFleetsRequest,
  GetLoggingOptionsRequest,
  GetRegisterAccountStatusRequest,
  BatchUpdateVehicleRequest,
  DeleteVehicleRequest,
  GetFleetRequest,
  ListDecoderManifestNetworkInterfacesRequest,
  GetModelManifestRequest,
  PutEncryptionConfigurationRequest,
  BatchCreateVehicleRequest,
  ListModelManifestNodesRequest,
  CreateSignalCatalogRequest,
  GetSignalCatalogRequest,
  ListModelManifestsRequest,
  GetVehicleStatusRequest,
  ListTagsForResourceRequest,
  RegisterAccountRequest,
  ListFleetsForVehicleRequest,
  UpdateCampaignRequest,
  GetCampaignRequest,
  GetEncryptionConfigurationRequest,
  CreateModelManifestRequest,
  ListVehiclesRequest,
  ListSignalCatalogsRequest,
  GetVehicleRequest,
  UpdateModelManifestRequest,
  GetDecoderManifestRequest,
  UpdateDecoderManifestRequest,
  UpdateSignalCatalogRequest,
  CreateCampaignRequest,
  DisassociateVehicleFleetRequest,
  DeleteCampaignRequest,
  ListDecoderManifestSignalsRequest,
  AssociateVehicleFleetRequest,
  UpdateFleetRequest,
  CreateFleetRequest,
  CreateVehicleRequest,
  PutLoggingOptionsRequest,
  DeleteDecoderManifestRequest,
  DeleteModelManifestRequest,
  UntagResourceRequest,
  ListDecoderManifestsRequest,
  DeleteSignalCatalogRequest,
  UpdateVehicleRequest,
  ListCampaignsRequest,
  ImportDecoderManifestRequest,
  ListSignalCatalogNodesRequest,
  TagResourceRequest,
  DeleteFleetRequest
}
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseAsyncClient
import zio.stream.ZStream
import zio.aws.iotfleetwise.model.primitives.{VehicleName, FleetId}
object IoTFleetWiseMock extends Mock[IoTFleetWise] {
  object ListDecoderManifestNetworkInterfaces
      extends Stream[
        ListDecoderManifestNetworkInterfacesRequest,
        AwsError,
        zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly
      ]
  object ListDecoderManifestNetworkInterfacesPaginated
      extends Effect[
        ListDecoderManifestNetworkInterfacesRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse.ReadOnly
      ]
  object GetDecoderManifest
      extends Effect[
        GetDecoderManifestRequest,
        AwsError,
        zio.aws.iotfleetwise.model.GetDecoderManifestResponse.ReadOnly
      ]
  object DeleteCampaign
      extends Effect[
        DeleteCampaignRequest,
        AwsError,
        zio.aws.iotfleetwise.model.DeleteCampaignResponse.ReadOnly
      ]
  object GetCampaign
      extends Effect[
        GetCampaignRequest,
        AwsError,
        zio.aws.iotfleetwise.model.GetCampaignResponse.ReadOnly
      ]
  object UpdateVehicle
      extends Effect[
        UpdateVehicleRequest,
        AwsError,
        zio.aws.iotfleetwise.model.UpdateVehicleResponse.ReadOnly
      ]
  object DeleteModelManifest
      extends Effect[
        DeleteModelManifestRequest,
        AwsError,
        zio.aws.iotfleetwise.model.DeleteModelManifestResponse.ReadOnly
      ]
  object ListCampaigns
      extends Stream[
        ListCampaignsRequest,
        AwsError,
        zio.aws.iotfleetwise.model.CampaignSummary.ReadOnly
      ]
  object ListCampaignsPaginated
      extends Effect[
        ListCampaignsRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ListCampaignsResponse.ReadOnly
      ]
  object RegisterAccount
      extends Effect[
        RegisterAccountRequest,
        AwsError,
        zio.aws.iotfleetwise.model.RegisterAccountResponse.ReadOnly
      ]
  object DeleteVehicle
      extends Effect[
        DeleteVehicleRequest,
        AwsError,
        zio.aws.iotfleetwise.model.DeleteVehicleResponse.ReadOnly
      ]
  object DeleteDecoderManifest
      extends Effect[
        DeleteDecoderManifestRequest,
        AwsError,
        zio.aws.iotfleetwise.model.DeleteDecoderManifestResponse.ReadOnly
      ]
  object ImportSignalCatalog
      extends Effect[
        ImportSignalCatalogRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ImportSignalCatalogResponse.ReadOnly
      ]
  object ListFleetsForVehicle
      extends Stream[ListFleetsForVehicleRequest, AwsError, FleetId]
  object ListFleetsForVehiclePaginated
      extends Effect[
        ListFleetsForVehicleRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ListFleetsForVehicleResponse.ReadOnly
      ]
  object DisassociateVehicleFleet
      extends Effect[
        DisassociateVehicleFleetRequest,
        AwsError,
        zio.aws.iotfleetwise.model.DisassociateVehicleFleetResponse.ReadOnly
      ]
  object ListFleets
      extends Stream[
        ListFleetsRequest,
        AwsError,
        zio.aws.iotfleetwise.model.FleetSummary.ReadOnly
      ]
  object ListFleetsPaginated
      extends Effect[
        ListFleetsRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ListFleetsResponse.ReadOnly
      ]
  object ListSignalCatalogNodes
      extends Stream[
        ListSignalCatalogNodesRequest,
        AwsError,
        zio.aws.iotfleetwise.model.Node.ReadOnly
      ]
  object ListSignalCatalogNodesPaginated
      extends Effect[
        ListSignalCatalogNodesRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ListSignalCatalogNodesResponse.ReadOnly
      ]
  object PutEncryptionConfiguration
      extends Effect[
        PutEncryptionConfigurationRequest,
        AwsError,
        zio.aws.iotfleetwise.model.PutEncryptionConfigurationResponse.ReadOnly
      ]
  object ImportDecoderManifest
      extends Effect[
        ImportDecoderManifestRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ImportDecoderManifestResponse.ReadOnly
      ]
  object CreateVehicle
      extends Effect[
        CreateVehicleRequest,
        AwsError,
        zio.aws.iotfleetwise.model.CreateVehicleResponse.ReadOnly
      ]
  object UpdateSignalCatalog
      extends Effect[UpdateSignalCatalogRequest, AwsError, ReadOnly]
  object ListModelManifests
      extends Stream[
        ListModelManifestsRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ModelManifestSummary.ReadOnly
      ]
  object ListModelManifestsPaginated
      extends Effect[
        ListModelManifestsRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ListModelManifestsResponse.ReadOnly
      ]
  object DeleteFleet
      extends Effect[
        DeleteFleetRequest,
        AwsError,
        zio.aws.iotfleetwise.model.DeleteFleetResponse.ReadOnly
      ]
  object PutLoggingOptions
      extends Effect[
        PutLoggingOptionsRequest,
        AwsError,
        zio.aws.iotfleetwise.model.PutLoggingOptionsResponse.ReadOnly
      ]
  object ListVehicles
      extends Stream[
        ListVehiclesRequest,
        AwsError,
        zio.aws.iotfleetwise.model.VehicleSummary.ReadOnly
      ]
  object ListVehiclesPaginated
      extends Effect[
        ListVehiclesRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ListVehiclesResponse.ReadOnly
      ]
  object UpdateFleet
      extends Effect[
        UpdateFleetRequest,
        AwsError,
        zio.aws.iotfleetwise.model.UpdateFleetResponse.ReadOnly
      ]
  object CreateModelManifest
      extends Effect[
        CreateModelManifestRequest,
        AwsError,
        zio.aws.iotfleetwise.model.CreateModelManifestResponse.ReadOnly
      ]
  object ListDecoderManifests
      extends Stream[
        ListDecoderManifestsRequest,
        AwsError,
        zio.aws.iotfleetwise.model.DecoderManifestSummary.ReadOnly
      ]
  object ListDecoderManifestsPaginated
      extends Effect[
        ListDecoderManifestsRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ListDecoderManifestsResponse.ReadOnly
      ]
  object GetFleet
      extends Effect[
        GetFleetRequest,
        AwsError,
        zio.aws.iotfleetwise.model.GetFleetResponse.ReadOnly
      ]
  object DeleteSignalCatalog
      extends Effect[
        DeleteSignalCatalogRequest,
        AwsError,
        zio.aws.iotfleetwise.model.DeleteSignalCatalogResponse.ReadOnly
      ]
  object GetModelManifest
      extends Effect[
        GetModelManifestRequest,
        AwsError,
        zio.aws.iotfleetwise.model.GetModelManifestResponse.ReadOnly
      ]
  object CreateFleet
      extends Effect[
        CreateFleetRequest,
        AwsError,
        zio.aws.iotfleetwise.model.CreateFleetResponse.ReadOnly
      ]
  object GetVehicle
      extends Effect[
        GetVehicleRequest,
        AwsError,
        zio.aws.iotfleetwise.model.GetVehicleResponse.ReadOnly
      ]
  object GetRegisterAccountStatus
      extends Effect[
        GetRegisterAccountStatusRequest,
        AwsError,
        zio.aws.iotfleetwise.model.GetRegisterAccountStatusResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.iotfleetwise.model.UntagResourceResponse.ReadOnly
      ]
  object ListDecoderManifestSignals
      extends Stream[
        ListDecoderManifestSignalsRequest,
        AwsError,
        zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly
      ]
  object ListDecoderManifestSignalsPaginated
      extends Effect[
        ListDecoderManifestSignalsRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ListDecoderManifestSignalsResponse.ReadOnly
      ]
  object BatchUpdateVehicle
      extends Effect[
        BatchUpdateVehicleRequest,
        AwsError,
        zio.aws.iotfleetwise.model.BatchUpdateVehicleResponse.ReadOnly
      ]
  object AssociateVehicleFleet
      extends Effect[
        AssociateVehicleFleetRequest,
        AwsError,
        zio.aws.iotfleetwise.model.AssociateVehicleFleetResponse.ReadOnly
      ]
  object CreateCampaign
      extends Effect[
        CreateCampaignRequest,
        AwsError,
        zio.aws.iotfleetwise.model.CreateCampaignResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetEncryptionConfiguration
      extends Effect[
        GetEncryptionConfigurationRequest,
        AwsError,
        zio.aws.iotfleetwise.model.GetEncryptionConfigurationResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.iotfleetwise.model.TagResourceResponse.ReadOnly
      ]
  object GetVehicleStatus
      extends Stream[
        GetVehicleStatusRequest,
        AwsError,
        zio.aws.iotfleetwise.model.VehicleStatus.ReadOnly
      ]
  object GetVehicleStatusPaginated
      extends Effect[
        GetVehicleStatusRequest,
        AwsError,
        zio.aws.iotfleetwise.model.GetVehicleStatusResponse.ReadOnly
      ]
  object ListSignalCatalogs
      extends Stream[
        ListSignalCatalogsRequest,
        AwsError,
        zio.aws.iotfleetwise.model.SignalCatalogSummary.ReadOnly
      ]
  object ListSignalCatalogsPaginated
      extends Effect[
        ListSignalCatalogsRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ListSignalCatalogsResponse.ReadOnly
      ]
  object ListModelManifestNodes
      extends Stream[
        ListModelManifestNodesRequest,
        AwsError,
        zio.aws.iotfleetwise.model.Node.ReadOnly
      ]
  object ListModelManifestNodesPaginated
      extends Effect[
        ListModelManifestNodesRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ListModelManifestNodesResponse.ReadOnly
      ]
  object CreateSignalCatalog
      extends Effect[
        CreateSignalCatalogRequest,
        AwsError,
        zio.aws.iotfleetwise.model.CreateSignalCatalogResponse.ReadOnly
      ]
  object BatchCreateVehicle
      extends Effect[
        BatchCreateVehicleRequest,
        AwsError,
        zio.aws.iotfleetwise.model.BatchCreateVehicleResponse.ReadOnly
      ]
  object GetLoggingOptions
      extends Effect[
        GetLoggingOptionsRequest,
        AwsError,
        zio.aws.iotfleetwise.model.GetLoggingOptionsResponse.ReadOnly
      ]
  object UpdateDecoderManifest
      extends Effect[
        UpdateDecoderManifestRequest,
        AwsError,
        zio.aws.iotfleetwise.model.UpdateDecoderManifestResponse.ReadOnly
      ]
  object CreateDecoderManifest
      extends Effect[
        CreateDecoderManifestRequest,
        AwsError,
        zio.aws.iotfleetwise.model.CreateDecoderManifestResponse.ReadOnly
      ]
  object ListVehiclesInFleet
      extends Stream[ListVehiclesInFleetRequest, AwsError, VehicleName]
  object ListVehiclesInFleetPaginated
      extends Effect[
        ListVehiclesInFleetRequest,
        AwsError,
        zio.aws.iotfleetwise.model.ListVehiclesInFleetResponse.ReadOnly
      ]
  object UpdateModelManifest
      extends Effect[
        UpdateModelManifestRequest,
        AwsError,
        zio.aws.iotfleetwise.model.UpdateModelManifestResponse.ReadOnly
      ]
  object UpdateCampaign
      extends Effect[
        UpdateCampaignRequest,
        AwsError,
        zio.aws.iotfleetwise.model.UpdateCampaignResponse.ReadOnly
      ]
  object GetSignalCatalog
      extends Effect[
        GetSignalCatalogRequest,
        AwsError,
        zio.aws.iotfleetwise.model.GetSignalCatalogResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, IoTFleetWise] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, IoTFleetWise] { rts =>
        zio.ZIO.succeed {
          new IoTFleetWise {
            val api: IoTFleetWiseAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): IoTFleetWise = this
            def listDecoderManifestNetworkInterfaces(
                request: ListDecoderManifestNetworkInterfacesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDecoderManifestNetworkInterfaces, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDecoderManifestNetworkInterfacesPaginated(
                request: ListDecoderManifestNetworkInterfacesRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse.ReadOnly
            ] = proxy(ListDecoderManifestNetworkInterfacesPaginated, request)
            def getDecoderManifest(request: GetDecoderManifestRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.GetDecoderManifestResponse.ReadOnly
            ] = proxy(GetDecoderManifest, request)
            def deleteCampaign(request: DeleteCampaignRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.DeleteCampaignResponse.ReadOnly
            ] = proxy(DeleteCampaign, request)
            def getCampaign(request: GetCampaignRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.GetCampaignResponse.ReadOnly
            ] = proxy(GetCampaign, request)
            def updateVehicle(request: UpdateVehicleRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.UpdateVehicleResponse.ReadOnly
            ] = proxy(UpdateVehicle, request)
            def deleteModelManifest(request: DeleteModelManifestRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.DeleteModelManifestResponse.ReadOnly
            ] = proxy(DeleteModelManifest, request)
            def listCampaigns(request: ListCampaignsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotfleetwise.model.CampaignSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListCampaigns, request)
                }
                .getOrThrowFiberFailure()
            }
            def listCampaignsPaginated(request: ListCampaignsRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ListCampaignsResponse.ReadOnly
            ] = proxy(ListCampaignsPaginated, request)
            def registerAccount(request: RegisterAccountRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.RegisterAccountResponse.ReadOnly
            ] = proxy(RegisterAccount, request)
            def deleteVehicle(request: DeleteVehicleRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.DeleteVehicleResponse.ReadOnly
            ] = proxy(DeleteVehicle, request)
            def deleteDecoderManifest(
                request: DeleteDecoderManifestRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.DeleteDecoderManifestResponse.ReadOnly
            ] = proxy(DeleteDecoderManifest, request)
            def importSignalCatalog(request: ImportSignalCatalogRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ImportSignalCatalogResponse.ReadOnly
            ] = proxy(ImportSignalCatalog, request)
            def listFleetsForVehicle(
                request: ListFleetsForVehicleRequest
            ): ZStream[Any, AwsError, FleetId] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListFleetsForVehicle, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listFleetsForVehiclePaginated(
                request: ListFleetsForVehicleRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ListFleetsForVehicleResponse.ReadOnly
            ] = proxy(ListFleetsForVehiclePaginated, request)
            def disassociateVehicleFleet(
                request: DisassociateVehicleFleetRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.DisassociateVehicleFleetResponse.ReadOnly
            ] = proxy(DisassociateVehicleFleet, request)
            def listFleets(request: ListFleetsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotfleetwise.model.FleetSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListFleets, request)
                }
                .getOrThrowFiberFailure()
            }
            def listFleetsPaginated(request: ListFleetsRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ListFleetsResponse.ReadOnly
            ] = proxy(ListFleetsPaginated, request)
            def listSignalCatalogNodes(
                request: ListSignalCatalogNodesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotfleetwise.model.Node.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSignalCatalogNodes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSignalCatalogNodesPaginated(
                request: ListSignalCatalogNodesRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ListSignalCatalogNodesResponse.ReadOnly
            ] = proxy(ListSignalCatalogNodesPaginated, request)
            def putEncryptionConfiguration(
                request: PutEncryptionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.PutEncryptionConfigurationResponse.ReadOnly
            ] = proxy(PutEncryptionConfiguration, request)
            def importDecoderManifest(
                request: ImportDecoderManifestRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ImportDecoderManifestResponse.ReadOnly
            ] = proxy(ImportDecoderManifest, request)
            def createVehicle(request: CreateVehicleRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.CreateVehicleResponse.ReadOnly
            ] = proxy(CreateVehicle, request)
            def updateSignalCatalog(
                request: UpdateSignalCatalogRequest
            ): IO[AwsError, ReadOnly] = proxy(UpdateSignalCatalog, request)
            def listModelManifests(request: ListModelManifestsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotfleetwise.model.ModelManifestSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelManifests, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelManifestsPaginated(
                request: ListModelManifestsRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ListModelManifestsResponse.ReadOnly
            ] = proxy(ListModelManifestsPaginated, request)
            def deleteFleet(request: DeleteFleetRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.DeleteFleetResponse.ReadOnly
            ] = proxy(DeleteFleet, request)
            def putLoggingOptions(request: PutLoggingOptionsRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.PutLoggingOptionsResponse.ReadOnly
            ] = proxy(PutLoggingOptions, request)
            def listVehicles(request: ListVehiclesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotfleetwise.model.VehicleSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVehicles, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVehiclesPaginated(request: ListVehiclesRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ListVehiclesResponse.ReadOnly
            ] = proxy(ListVehiclesPaginated, request)
            def updateFleet(request: UpdateFleetRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.UpdateFleetResponse.ReadOnly
            ] = proxy(UpdateFleet, request)
            def createModelManifest(request: CreateModelManifestRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.CreateModelManifestResponse.ReadOnly
            ] = proxy(CreateModelManifest, request)
            def listDecoderManifests(
                request: ListDecoderManifestsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotfleetwise.model.DecoderManifestSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDecoderManifests, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDecoderManifestsPaginated(
                request: ListDecoderManifestsRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ListDecoderManifestsResponse.ReadOnly
            ] = proxy(ListDecoderManifestsPaginated, request)
            def getFleet(request: GetFleetRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.GetFleetResponse.ReadOnly
            ] = proxy(GetFleet, request)
            def deleteSignalCatalog(request: DeleteSignalCatalogRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.DeleteSignalCatalogResponse.ReadOnly
            ] = proxy(DeleteSignalCatalog, request)
            def getModelManifest(request: GetModelManifestRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.GetModelManifestResponse.ReadOnly
            ] = proxy(GetModelManifest, request)
            def createFleet(request: CreateFleetRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.CreateFleetResponse.ReadOnly
            ] = proxy(CreateFleet, request)
            def getVehicle(request: GetVehicleRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.GetVehicleResponse.ReadOnly
            ] = proxy(GetVehicle, request)
            def getRegisterAccountStatus(
                request: GetRegisterAccountStatusRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.GetRegisterAccountStatusResponse.ReadOnly
            ] = proxy(GetRegisterAccountStatus, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listDecoderManifestSignals(
                request: ListDecoderManifestSignalsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDecoderManifestSignals, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDecoderManifestSignalsPaginated(
                request: ListDecoderManifestSignalsRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ListDecoderManifestSignalsResponse.ReadOnly
            ] = proxy(ListDecoderManifestSignalsPaginated, request)
            def batchUpdateVehicle(request: BatchUpdateVehicleRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.BatchUpdateVehicleResponse.ReadOnly
            ] = proxy(BatchUpdateVehicle, request)
            def associateVehicleFleet(
                request: AssociateVehicleFleetRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.AssociateVehicleFleetResponse.ReadOnly
            ] = proxy(AssociateVehicleFleet, request)
            def createCampaign(request: CreateCampaignRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.CreateCampaignResponse.ReadOnly
            ] = proxy(CreateCampaign, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def getEncryptionConfiguration(
                request: GetEncryptionConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.GetEncryptionConfigurationResponse.ReadOnly
            ] = proxy(GetEncryptionConfiguration, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def getVehicleStatus(request: GetVehicleStatusRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotfleetwise.model.VehicleStatus.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(GetVehicleStatus, request)
                }
                .getOrThrowFiberFailure()
            }
            def getVehicleStatusPaginated(request: GetVehicleStatusRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.GetVehicleStatusResponse.ReadOnly
            ] = proxy(GetVehicleStatusPaginated, request)
            def listSignalCatalogs(request: ListSignalCatalogsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.iotfleetwise.model.SignalCatalogSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListSignalCatalogs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listSignalCatalogsPaginated(
                request: ListSignalCatalogsRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ListSignalCatalogsResponse.ReadOnly
            ] = proxy(ListSignalCatalogsPaginated, request)
            def listModelManifestNodes(
                request: ListModelManifestNodesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.iotfleetwise.model.Node.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListModelManifestNodes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listModelManifestNodesPaginated(
                request: ListModelManifestNodesRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ListModelManifestNodesResponse.ReadOnly
            ] = proxy(ListModelManifestNodesPaginated, request)
            def createSignalCatalog(request: CreateSignalCatalogRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.CreateSignalCatalogResponse.ReadOnly
            ] = proxy(CreateSignalCatalog, request)
            def batchCreateVehicle(request: BatchCreateVehicleRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.BatchCreateVehicleResponse.ReadOnly
            ] = proxy(BatchCreateVehicle, request)
            def getLoggingOptions(request: GetLoggingOptionsRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.GetLoggingOptionsResponse.ReadOnly
            ] = proxy(GetLoggingOptions, request)
            def updateDecoderManifest(
                request: UpdateDecoderManifestRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.UpdateDecoderManifestResponse.ReadOnly
            ] = proxy(UpdateDecoderManifest, request)
            def createDecoderManifest(
                request: CreateDecoderManifestRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.CreateDecoderManifestResponse.ReadOnly
            ] = proxy(CreateDecoderManifest, request)
            def listVehiclesInFleet(
                request: ListVehiclesInFleetRequest
            ): ZStream[Any, AwsError, VehicleName] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListVehiclesInFleet, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listVehiclesInFleetPaginated(
                request: ListVehiclesInFleetRequest
            ): IO[
              AwsError,
              zio.aws.iotfleetwise.model.ListVehiclesInFleetResponse.ReadOnly
            ] = proxy(ListVehiclesInFleetPaginated, request)
            def updateModelManifest(request: UpdateModelManifestRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.UpdateModelManifestResponse.ReadOnly
            ] = proxy(UpdateModelManifest, request)
            def updateCampaign(request: UpdateCampaignRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.UpdateCampaignResponse.ReadOnly
            ] = proxy(UpdateCampaign, request)
            def getSignalCatalog(request: GetSignalCatalogRequest): IO[
              AwsError,
              zio.aws.iotfleetwise.model.GetSignalCatalogResponse.ReadOnly
            ] = proxy(GetSignalCatalog, request)
          }
        }
      }
    }
  }
}
