package zio.aws.iotfleetwise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchCreateVehicleResponse(
    vehicles: Optional[
      Iterable[zio.aws.iotfleetwise.model.CreateVehicleResponseItem]
    ] = Optional.Absent,
    errors: Optional[Iterable[zio.aws.iotfleetwise.model.CreateVehicleError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleResponse = {
    import BatchCreateVehicleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleResponse
      .builder()
      .optionallyWith(
        vehicles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vehicles)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.BatchCreateVehicleResponse.ReadOnly =
    zio.aws.iotfleetwise.model.BatchCreateVehicleResponse.wrap(buildAwsValue())
}
object BatchCreateVehicleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.BatchCreateVehicleResponse =
      zio.aws.iotfleetwise.model.BatchCreateVehicleResponse(
        vehicles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vehicles: Optional[
      List[zio.aws.iotfleetwise.model.CreateVehicleResponseItem.ReadOnly]
    ]
    def errors
        : Optional[List[zio.aws.iotfleetwise.model.CreateVehicleError.ReadOnly]]
    def getVehicles: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.CreateVehicleResponseItem.ReadOnly
    ]] = AwsError.unwrapOptionField("vehicles", vehicles)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.CreateVehicleError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleResponse
  ) extends zio.aws.iotfleetwise.model.BatchCreateVehicleResponse.ReadOnly {
    override val vehicles: Optional[
      List[zio.aws.iotfleetwise.model.CreateVehicleResponseItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vehicles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.CreateVehicleResponseItem.wrap(item)
        }.toList
      )
    override val errors: Optional[
      List[zio.aws.iotfleetwise.model.CreateVehicleError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.CreateVehicleError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.BatchCreateVehicleResponse
  ): zio.aws.iotfleetwise.model.BatchCreateVehicleResponse.ReadOnly =
    new Wrapper(impl)
}
