package zio.aws.iotfleetwise.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchUpdateVehicleRequest(
    vehicles: Iterable[zio.aws.iotfleetwise.model.UpdateVehicleRequestItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleRequest = {
    import BatchUpdateVehicleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleRequest
      .builder()
      .vehicles(vehicles.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.BatchUpdateVehicleRequest.ReadOnly =
    zio.aws.iotfleetwise.model.BatchUpdateVehicleRequest.wrap(buildAwsValue())
}
object BatchUpdateVehicleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.BatchUpdateVehicleRequest =
      zio.aws.iotfleetwise.model.BatchUpdateVehicleRequest(vehicles.map {
        item =>
          item.asEditable
      })
    def vehicles
        : List[zio.aws.iotfleetwise.model.UpdateVehicleRequestItem.ReadOnly]
    def getVehicles: ZIO[Any, Nothing, List[
      zio.aws.iotfleetwise.model.UpdateVehicleRequestItem.ReadOnly
    ]] = ZIO.succeed(vehicles)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleRequest
  ) extends zio.aws.iotfleetwise.model.BatchUpdateVehicleRequest.ReadOnly {
    override val vehicles
        : List[zio.aws.iotfleetwise.model.UpdateVehicleRequestItem.ReadOnly] =
      impl
        .vehicles()
        .asScala
        .map { item =>
          zio.aws.iotfleetwise.model.UpdateVehicleRequestItem.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleRequest
  ): zio.aws.iotfleetwise.model.BatchUpdateVehicleRequest.ReadOnly =
    new Wrapper(impl)
}
