package zio.aws.iotfleetwise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchUpdateVehicleResponse(
    vehicles: Optional[
      Iterable[zio.aws.iotfleetwise.model.UpdateVehicleResponseItem]
    ] = Optional.Absent,
    errors: Optional[Iterable[zio.aws.iotfleetwise.model.UpdateVehicleError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleResponse = {
    import BatchUpdateVehicleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleResponse
      .builder()
      .optionallyWith(
        vehicles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vehicles)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.BatchUpdateVehicleResponse.ReadOnly =
    zio.aws.iotfleetwise.model.BatchUpdateVehicleResponse.wrap(buildAwsValue())
}
object BatchUpdateVehicleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.BatchUpdateVehicleResponse =
      zio.aws.iotfleetwise.model.BatchUpdateVehicleResponse(
        vehicles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vehicles: Optional[
      List[zio.aws.iotfleetwise.model.UpdateVehicleResponseItem.ReadOnly]
    ]
    def errors
        : Optional[List[zio.aws.iotfleetwise.model.UpdateVehicleError.ReadOnly]]
    def getVehicles: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.UpdateVehicleResponseItem.ReadOnly
    ]] = AwsError.unwrapOptionField("vehicles", vehicles)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.UpdateVehicleError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleResponse
  ) extends zio.aws.iotfleetwise.model.BatchUpdateVehicleResponse.ReadOnly {
    override val vehicles: Optional[
      List[zio.aws.iotfleetwise.model.UpdateVehicleResponseItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vehicles())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.UpdateVehicleResponseItem.wrap(item)
        }.toList
      )
    override val errors: Optional[
      List[zio.aws.iotfleetwise.model.UpdateVehicleError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.UpdateVehicleError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.BatchUpdateVehicleResponse
  ): zio.aws.iotfleetwise.model.BatchUpdateVehicleResponse.ReadOnly =
    new Wrapper(impl)
}
