package zio.aws.iotfleetwise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotfleetwise.model.primitives.{
  Timestamp,
  Description,
  CampaignName,
  Arn
}
import scala.jdk.CollectionConverters.*
final case class CampaignSummary(
    arn: Optional[Arn] = Optional.Absent,
    name: Optional[CampaignName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    signalCatalogArn: Optional[Arn] = Optional.Absent,
    targetArn: Optional[Arn] = Optional.Absent,
    status: Optional[zio.aws.iotfleetwise.model.CampaignStatus] =
      Optional.Absent,
    creationTime: Timestamp,
    lastModificationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CampaignSummary = {
    import CampaignSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CampaignSummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        name.map(value => CampaignName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        signalCatalogArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.signalCatalogArn)
      .optionallyWith(
        targetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.targetArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModificationTime(Timestamp.unwrap(lastModificationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.CampaignSummary.ReadOnly =
    zio.aws.iotfleetwise.model.CampaignSummary.wrap(buildAwsValue())
}
object CampaignSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CampaignSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CampaignSummary =
      zio.aws.iotfleetwise.model.CampaignSummary(
        arn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        signalCatalogArn.map(value => value),
        targetArn.map(value => value),
        status.map(value => value),
        creationTime,
        lastModificationTime
      )
    def arn: Optional[Arn]
    def name: Optional[CampaignName]
    def description: Optional[Description]
    def signalCatalogArn: Optional[Arn]
    def targetArn: Optional[Arn]
    def status: Optional[zio.aws.iotfleetwise.model.CampaignStatus]
    def creationTime: Timestamp
    def lastModificationTime: Timestamp
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, CampaignName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSignalCatalogArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("signalCatalogArn", signalCatalogArn)
    def getTargetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.CampaignStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModificationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CampaignSummary
  ) extends zio.aws.iotfleetwise.model.CampaignSummary.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val name: Optional[CampaignName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotfleetwise.model.primitives.CampaignName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val signalCatalogArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.signalCatalogArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val targetArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val status: Optional[zio.aws.iotfleetwise.model.CampaignStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotfleetwise.model.CampaignStatus.wrap(value))
    override val creationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives.Timestamp(impl.creationTime())
    override val lastModificationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives
        .Timestamp(impl.lastModificationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CampaignSummary
  ): zio.aws.iotfleetwise.model.CampaignSummary.ReadOnly = new Wrapper(impl)
}
