package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{
  ProtocolVersion,
  ProtocolName,
  CanInterfaceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CanInterface(
    name: CanInterfaceName,
    protocolName: Optional[ProtocolName] = Optional.Absent,
    protocolVersion: Optional[ProtocolVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CanInterface = {
    import CanInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CanInterface
      .builder()
      .name(CanInterfaceName.unwrap(name): java.lang.String)
      .optionallyWith(
        protocolName.map(value => ProtocolName.unwrap(value): java.lang.String)
      )(_.protocolName)
      .optionallyWith(
        protocolVersion.map(value =>
          ProtocolVersion.unwrap(value): java.lang.String
        )
      )(_.protocolVersion)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.CanInterface.ReadOnly =
    zio.aws.iotfleetwise.model.CanInterface.wrap(buildAwsValue())
}
object CanInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CanInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CanInterface =
      zio.aws.iotfleetwise.model.CanInterface(
        name,
        protocolName.map(value => value),
        protocolVersion.map(value => value)
      )
    def name: CanInterfaceName
    def protocolName: Optional[ProtocolName]
    def protocolVersion: Optional[ProtocolVersion]
    def getName: ZIO[Any, Nothing, CanInterfaceName] = ZIO.succeed(name)
    def getProtocolName: ZIO[Any, AwsError, ProtocolName] =
      AwsError.unwrapOptionField("protocolName", protocolName)
    def getProtocolVersion: ZIO[Any, AwsError, ProtocolVersion] =
      AwsError.unwrapOptionField("protocolVersion", protocolVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CanInterface
  ) extends zio.aws.iotfleetwise.model.CanInterface.ReadOnly {
    override val name: CanInterfaceName =
      zio.aws.iotfleetwise.model.primitives.CanInterfaceName(impl.name())
    override val protocolName: Optional[ProtocolName] = zio.aws.core.internal
      .optionalFromNullable(impl.protocolName())
      .map(value => zio.aws.iotfleetwise.model.primitives.ProtocolName(value))
    override val protocolVersion: Optional[ProtocolVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocolVersion())
        .map(value =>
          zio.aws.iotfleetwise.model.primitives.ProtocolVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CanInterface
  ): zio.aws.iotfleetwise.model.CanInterface.ReadOnly = new Wrapper(impl)
}
