package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.CloudWatchLogGroupName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CloudWatchLogDeliveryOptions(
    logType: zio.aws.iotfleetwise.model.LogType,
    logGroupName: Optional[CloudWatchLogGroupName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CloudWatchLogDeliveryOptions = {
    import CloudWatchLogDeliveryOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CloudWatchLogDeliveryOptions
      .builder()
      .logType(logType.unwrap)
      .optionallyWith(
        logGroupName.map(value =>
          CloudWatchLogGroupName.unwrap(value): java.lang.String
        )
      )(_.logGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.CloudWatchLogDeliveryOptions.ReadOnly =
    zio.aws.iotfleetwise.model.CloudWatchLogDeliveryOptions
      .wrap(buildAwsValue())
}
object CloudWatchLogDeliveryOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CloudWatchLogDeliveryOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CloudWatchLogDeliveryOptions =
      zio.aws.iotfleetwise.model
        .CloudWatchLogDeliveryOptions(logType, logGroupName.map(value => value))
    def logType: zio.aws.iotfleetwise.model.LogType
    def logGroupName: Optional[CloudWatchLogGroupName]
    def getLogType: ZIO[Any, Nothing, zio.aws.iotfleetwise.model.LogType] =
      ZIO.succeed(logType)
    def getLogGroupName: ZIO[Any, AwsError, CloudWatchLogGroupName] =
      AwsError.unwrapOptionField("logGroupName", logGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CloudWatchLogDeliveryOptions
  ) extends zio.aws.iotfleetwise.model.CloudWatchLogDeliveryOptions.ReadOnly {
    override val logType: zio.aws.iotfleetwise.model.LogType =
      zio.aws.iotfleetwise.model.LogType.wrap(impl.logType())
    override val logGroupName: Optional[CloudWatchLogGroupName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logGroupName())
        .map(value =>
          zio.aws.iotfleetwise.model.primitives.CloudWatchLogGroupName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CloudWatchLogDeliveryOptions
  ): zio.aws.iotfleetwise.model.CloudWatchLogDeliveryOptions.ReadOnly =
    new Wrapper(impl)
}
