package zio.aws.iotfleetwise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CollectionScheme(
    timeBasedCollectionScheme: Optional[
      zio.aws.iotfleetwise.model.TimeBasedCollectionScheme
    ] = Optional.Absent,
    conditionBasedCollectionScheme: Optional[
      zio.aws.iotfleetwise.model.ConditionBasedCollectionScheme
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CollectionScheme = {
    import CollectionScheme.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CollectionScheme
      .builder()
      .optionallyWith(
        timeBasedCollectionScheme.map(value => value.buildAwsValue())
      )(_.timeBasedCollectionScheme)
      .optionallyWith(
        conditionBasedCollectionScheme.map(value => value.buildAwsValue())
      )(_.conditionBasedCollectionScheme)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.CollectionScheme.ReadOnly =
    zio.aws.iotfleetwise.model.CollectionScheme.wrap(buildAwsValue())
}
object CollectionScheme {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CollectionScheme
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CollectionScheme =
      zio.aws.iotfleetwise.model.CollectionScheme(
        timeBasedCollectionScheme.map(value => value.asEditable),
        conditionBasedCollectionScheme.map(value => value.asEditable)
      )
    def timeBasedCollectionScheme: Optional[
      zio.aws.iotfleetwise.model.TimeBasedCollectionScheme.ReadOnly
    ]
    def conditionBasedCollectionScheme: Optional[
      zio.aws.iotfleetwise.model.ConditionBasedCollectionScheme.ReadOnly
    ]
    def getTimeBasedCollectionScheme: ZIO[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.TimeBasedCollectionScheme.ReadOnly
    ] = AwsError.unwrapOptionField(
      "timeBasedCollectionScheme",
      timeBasedCollectionScheme
    )
    def getConditionBasedCollectionScheme: ZIO[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.ConditionBasedCollectionScheme.ReadOnly
    ] = AwsError.unwrapOptionField(
      "conditionBasedCollectionScheme",
      conditionBasedCollectionScheme
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CollectionScheme
  ) extends zio.aws.iotfleetwise.model.CollectionScheme.ReadOnly {
    override val timeBasedCollectionScheme: Optional[
      zio.aws.iotfleetwise.model.TimeBasedCollectionScheme.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.timeBasedCollectionScheme())
      .map(value =>
        zio.aws.iotfleetwise.model.TimeBasedCollectionScheme.wrap(value)
      )
    override val conditionBasedCollectionScheme: Optional[
      zio.aws.iotfleetwise.model.ConditionBasedCollectionScheme.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.conditionBasedCollectionScheme())
      .map(value =>
        zio.aws.iotfleetwise.model.ConditionBasedCollectionScheme.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CollectionScheme
  ): zio.aws.iotfleetwise.model.CollectionScheme.ReadOnly = new Wrapper(impl)
}
