package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, Description, FleetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateFleetRequest(
    fleetId: FleetId,
    description: Optional[Description] = Optional.Absent,
    signalCatalogArn: Arn,
    tags: Optional[Iterable[zio.aws.iotfleetwise.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CreateFleetRequest = {
    import CreateFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CreateFleetRequest
      .builder()
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .signalCatalogArn(Arn.unwrap(signalCatalogArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.CreateFleetRequest.ReadOnly =
    zio.aws.iotfleetwise.model.CreateFleetRequest.wrap(buildAwsValue())
}
object CreateFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CreateFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CreateFleetRequest =
      zio.aws.iotfleetwise.model.CreateFleetRequest(
        fleetId,
        description.map(value => value),
        signalCatalogArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fleetId: FleetId
    def description: Optional[Description]
    def signalCatalogArn: Arn
    def tags: Optional[List[zio.aws.iotfleetwise.model.Tag.ReadOnly]]
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSignalCatalogArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(signalCatalogArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotfleetwise.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateFleetRequest
  ) extends zio.aws.iotfleetwise.model.CreateFleetRequest.ReadOnly {
    override val fleetId: FleetId =
      zio.aws.iotfleetwise.model.primitives.FleetId(impl.fleetId())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val signalCatalogArn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.signalCatalogArn())
    override val tags: Optional[List[zio.aws.iotfleetwise.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateFleetRequest
  ): zio.aws.iotfleetwise.model.CreateFleetRequest.ReadOnly = new Wrapper(impl)
}
