package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, FleetId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateFleetResponse(id: FleetId, arn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CreateFleetResponse = {
    import CreateFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CreateFleetResponse
      .builder()
      .id(FleetId.unwrap(id): java.lang.String)
      .arn(Arn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.CreateFleetResponse.ReadOnly =
    zio.aws.iotfleetwise.model.CreateFleetResponse.wrap(buildAwsValue())
}
object CreateFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CreateFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CreateFleetResponse =
      zio.aws.iotfleetwise.model.CreateFleetResponse(id, arn)
    def id: FleetId
    def arn: Arn
    def getId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateFleetResponse
  ) extends zio.aws.iotfleetwise.model.CreateFleetResponse.ReadOnly {
    override val id: FleetId =
      zio.aws.iotfleetwise.model.primitives.FleetId(impl.id())
    override val arn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateFleetResponse
  ): zio.aws.iotfleetwise.model.CreateFleetResponse.ReadOnly = new Wrapper(impl)
}
