package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, VehicleName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateVehicleResponseItem(
    vehicleName: Optional[VehicleName] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    thingArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleResponseItem = {
    import CreateVehicleResponseItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleResponseItem
      .builder()
      .optionallyWith(
        vehicleName.map(value => VehicleName.unwrap(value): java.lang.String)
      )(_.vehicleName)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        thingArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.CreateVehicleResponseItem.ReadOnly =
    zio.aws.iotfleetwise.model.CreateVehicleResponseItem.wrap(buildAwsValue())
}
object CreateVehicleResponseItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleResponseItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.CreateVehicleResponseItem =
      zio.aws.iotfleetwise.model.CreateVehicleResponseItem(
        vehicleName.map(value => value),
        arn.map(value => value),
        thingArn.map(value => value)
      )
    def vehicleName: Optional[VehicleName]
    def arn: Optional[Arn]
    def thingArn: Optional[Arn]
    def getVehicleName: ZIO[Any, AwsError, VehicleName] =
      AwsError.unwrapOptionField("vehicleName", vehicleName)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getThingArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleResponseItem
  ) extends zio.aws.iotfleetwise.model.CreateVehicleResponseItem.ReadOnly {
    override val vehicleName: Optional[VehicleName] = zio.aws.core.internal
      .optionalFromNullable(impl.vehicleName())
      .map(value => zio.aws.iotfleetwise.model.primitives.VehicleName(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val thingArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleResponseItem
  ): zio.aws.iotfleetwise.model.CreateVehicleResponseItem.ReadOnly =
    new Wrapper(impl)
}
