package zio.aws.iotfleetwise.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataDestinationConfig(
    s3Config: Optional[zio.aws.iotfleetwise.model.S3Config] = Optional.Absent,
    timestreamConfig: Optional[zio.aws.iotfleetwise.model.TimestreamConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig = {
    import DataDestinationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig
      .builder()
      .optionallyWith(s3Config.map(value => value.buildAwsValue()))(_.s3Config)
      .optionallyWith(timestreamConfig.map(value => value.buildAwsValue()))(
        _.timestreamConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.DataDestinationConfig.ReadOnly =
    zio.aws.iotfleetwise.model.DataDestinationConfig.wrap(buildAwsValue())
}
object DataDestinationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.DataDestinationConfig =
      zio.aws.iotfleetwise.model.DataDestinationConfig(
        s3Config.map(value => value.asEditable),
        timestreamConfig.map(value => value.asEditable)
      )
    def s3Config: Optional[zio.aws.iotfleetwise.model.S3Config.ReadOnly]
    def timestreamConfig
        : Optional[zio.aws.iotfleetwise.model.TimestreamConfig.ReadOnly]
    def getS3Config
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.S3Config.ReadOnly] =
      AwsError.unwrapOptionField("s3Config", s3Config)
    def getTimestreamConfig: ZIO[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.TimestreamConfig.ReadOnly
    ] = AwsError.unwrapOptionField("timestreamConfig", timestreamConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig
  ) extends zio.aws.iotfleetwise.model.DataDestinationConfig.ReadOnly {
    override val s3Config
        : Optional[zio.aws.iotfleetwise.model.S3Config.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Config())
        .map(value => zio.aws.iotfleetwise.model.S3Config.wrap(value))
    override val timestreamConfig
        : Optional[zio.aws.iotfleetwise.model.TimestreamConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timestreamConfig())
        .map(value => zio.aws.iotfleetwise.model.TimestreamConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DataDestinationConfig
  ): zio.aws.iotfleetwise.model.DataDestinationConfig.ReadOnly = new Wrapper(
    impl
  )
}
