package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters.*
sealed trait DataFormat {
  def unwrap: software.amazon.awssdk.services.iotfleetwise.model.DataFormat
}
object DataFormat {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.DataFormat
  ): zio.aws.iotfleetwise.model.DataFormat = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.DataFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.DataFormat.JSON =>
      val r = JSON
      r
    case software.amazon.awssdk.services.iotfleetwise.model.DataFormat.PARQUET =>
      val r = PARQUET
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleetwise.model.DataFormat {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.DataFormat =
      software.amazon.awssdk.services.iotfleetwise.model.DataFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object JSON extends zio.aws.iotfleetwise.model.DataFormat {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.DataFormat =
      software.amazon.awssdk.services.iotfleetwise.model.DataFormat.JSON
  }
  case object PARQUET extends zio.aws.iotfleetwise.model.DataFormat {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.DataFormat =
      software.amazon.awssdk.services.iotfleetwise.model.DataFormat.PARQUET
  }
}
