package zio.aws.iotfleetwise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotfleetwise.model.primitives.{Timestamp, Description, Arn}
import scala.jdk.CollectionConverters.*
final case class DecoderManifestSummary(
    name: Optional[String] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    modelManifestArn: Optional[Arn] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    status: Optional[zio.aws.iotfleetwise.model.ManifestStatus] =
      Optional.Absent,
    creationTime: Timestamp,
    lastModificationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.DecoderManifestSummary = {
    import DecoderManifestSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.DecoderManifestSummary
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        modelManifestArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.modelManifestArn)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModificationTime(Timestamp.unwrap(lastModificationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.DecoderManifestSummary.ReadOnly =
    zio.aws.iotfleetwise.model.DecoderManifestSummary.wrap(buildAwsValue())
}
object DecoderManifestSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.DecoderManifestSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.DecoderManifestSummary =
      zio.aws.iotfleetwise.model.DecoderManifestSummary(
        name.map(value => value),
        arn.map(value => value),
        modelManifestArn.map(value => value),
        description.map(value => value),
        status.map(value => value),
        creationTime,
        lastModificationTime
      )
    def name: Optional[String]
    def arn: Optional[Arn]
    def modelManifestArn: Optional[Arn]
    def description: Optional[Description]
    def status: Optional[zio.aws.iotfleetwise.model.ManifestStatus]
    def creationTime: Timestamp
    def lastModificationTime: Timestamp
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getModelManifestArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("modelManifestArn", modelManifestArn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.ManifestStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModificationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DecoderManifestSummary
  ) extends zio.aws.iotfleetwise.model.DecoderManifestSummary.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val modelManifestArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelManifestArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val status: Optional[zio.aws.iotfleetwise.model.ManifestStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotfleetwise.model.ManifestStatus.wrap(value))
    override val creationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives.Timestamp(impl.creationTime())
    override val lastModificationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives
        .Timestamp(impl.lastModificationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DecoderManifestSummary
  ): zio.aws.iotfleetwise.model.DecoderManifestSummary.ReadOnly = new Wrapper(
    impl
  )
}
