package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Arn, FleetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteFleetResponse(
    id: Optional[FleetId] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetResponse = {
    import DeleteFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetResponse
      .builder()
      .optionallyWith(id.map(value => FleetId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.DeleteFleetResponse.ReadOnly =
    zio.aws.iotfleetwise.model.DeleteFleetResponse.wrap(buildAwsValue())
}
object DeleteFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.DeleteFleetResponse =
      zio.aws.iotfleetwise.model
        .DeleteFleetResponse(id.map(value => value), arn.map(value => value))
    def id: Optional[FleetId]
    def arn: Optional[Arn]
    def getId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetResponse
  ) extends zio.aws.iotfleetwise.model.DeleteFleetResponse.ReadOnly {
    override val id: Optional[FleetId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.iotfleetwise.model.primitives.FleetId(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteFleetResponse
  ): zio.aws.iotfleetwise.model.DeleteFleetResponse.ReadOnly = new Wrapper(impl)
}
