package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.VehicleName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteVehicleRequest(vehicleName: VehicleName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleRequest = {
    import DeleteVehicleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleRequest
      .builder()
      .vehicleName(VehicleName.unwrap(vehicleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.DeleteVehicleRequest.ReadOnly =
    zio.aws.iotfleetwise.model.DeleteVehicleRequest.wrap(buildAwsValue())
}
object DeleteVehicleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.DeleteVehicleRequest =
      zio.aws.iotfleetwise.model.DeleteVehicleRequest(vehicleName)
    def vehicleName: VehicleName
    def getVehicleName: ZIO[Any, Nothing, VehicleName] =
      ZIO.succeed(vehicleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleRequest
  ) extends zio.aws.iotfleetwise.model.DeleteVehicleRequest.ReadOnly {
    override val vehicleName: VehicleName =
      zio.aws.iotfleetwise.model.primitives.VehicleName(impl.vehicleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DeleteVehicleRequest
  ): zio.aws.iotfleetwise.model.DeleteVehicleRequest.ReadOnly = new Wrapper(
    impl
  )
}
