package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters.*
sealed trait DiagnosticsMode {
  def unwrap: software.amazon.awssdk.services.iotfleetwise.model.DiagnosticsMode
}
object DiagnosticsMode {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.DiagnosticsMode
  ): zio.aws.iotfleetwise.model.DiagnosticsMode = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.DiagnosticsMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.DiagnosticsMode.OFF =>
      val r = OFF
      r
    case software.amazon.awssdk.services.iotfleetwise.model.DiagnosticsMode.SEND_ACTIVE_DTCS =>
      val r = SEND_ACTIVE_DTCS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleetwise.model.DiagnosticsMode {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.DiagnosticsMode =
      software.amazon.awssdk.services.iotfleetwise.model.DiagnosticsMode.UNKNOWN_TO_SDK_VERSION
  }
  case object OFF extends zio.aws.iotfleetwise.model.DiagnosticsMode {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.DiagnosticsMode =
      software.amazon.awssdk.services.iotfleetwise.model.DiagnosticsMode.OFF
  }
  case object SEND_ACTIVE_DTCS
      extends zio.aws.iotfleetwise.model.DiagnosticsMode {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.DiagnosticsMode =
      software.amazon.awssdk.services.iotfleetwise.model.DiagnosticsMode.SEND_ACTIVE_DTCS
  }
}
