package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{FleetId, VehicleName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisassociateVehicleFleetRequest(
    vehicleName: VehicleName,
    fleetId: FleetId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetRequest = {
    import DisassociateVehicleFleetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetRequest
      .builder()
      .vehicleName(VehicleName.unwrap(vehicleName): java.lang.String)
      .fleetId(FleetId.unwrap(fleetId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.DisassociateVehicleFleetRequest.ReadOnly =
    zio.aws.iotfleetwise.model.DisassociateVehicleFleetRequest
      .wrap(buildAwsValue())
}
object DisassociateVehicleFleetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.DisassociateVehicleFleetRequest =
      zio.aws.iotfleetwise.model
        .DisassociateVehicleFleetRequest(vehicleName, fleetId)
    def vehicleName: VehicleName
    def fleetId: FleetId
    def getVehicleName: ZIO[Any, Nothing, VehicleName] =
      ZIO.succeed(vehicleName)
    def getFleetId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetRequest
  ) extends zio.aws.iotfleetwise.model.DisassociateVehicleFleetRequest.ReadOnly {
    override val vehicleName: VehicleName =
      zio.aws.iotfleetwise.model.primitives.VehicleName(impl.vehicleName())
    override val fleetId: FleetId =
      zio.aws.iotfleetwise.model.primitives.FleetId(impl.fleetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.DisassociateVehicleFleetRequest
  ): zio.aws.iotfleetwise.model.DisassociateVehicleFleetRequest.ReadOnly =
    new Wrapper(impl)
}
