package zio.aws.iotfleetwise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.{
  Priority,
  Timestamp,
  Arn,
  CampaignName,
  Description,
  Uint32,
  NodePath
}
import scala.jdk.CollectionConverters.*
final case class GetCampaignResponse(
    name: Optional[CampaignName] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    signalCatalogArn: Optional[Arn] = Optional.Absent,
    targetArn: Optional[Arn] = Optional.Absent,
    status: Optional[zio.aws.iotfleetwise.model.CampaignStatus] =
      Optional.Absent,
    startTime: Optional[Timestamp] = Optional.Absent,
    expiryTime: Optional[Timestamp] = Optional.Absent,
    postTriggerCollectionDuration: Optional[Uint32] = Optional.Absent,
    diagnosticsMode: Optional[zio.aws.iotfleetwise.model.DiagnosticsMode] =
      Optional.Absent,
    spoolingMode: Optional[zio.aws.iotfleetwise.model.SpoolingMode] =
      Optional.Absent,
    compression: Optional[zio.aws.iotfleetwise.model.Compression] =
      Optional.Absent,
    priority: Optional[Priority] = Optional.Absent,
    signalsToCollect: Optional[
      Iterable[zio.aws.iotfleetwise.model.SignalInformation]
    ] = Optional.Absent,
    collectionScheme: Optional[zio.aws.iotfleetwise.model.CollectionScheme] =
      Optional.Absent,
    dataExtraDimensions: Optional[Iterable[NodePath]] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent,
    dataDestinationConfigs: Optional[
      Iterable[zio.aws.iotfleetwise.model.DataDestinationConfig]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.GetCampaignResponse = {
    import GetCampaignResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.GetCampaignResponse
      .builder()
      .optionallyWith(
        name.map(value => CampaignName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        signalCatalogArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.signalCatalogArn)
      .optionallyWith(
        targetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.targetArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        expiryTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.expiryTime)
      .optionallyWith(
        postTriggerCollectionDuration.map(value =>
          Uint32.unwrap(value): java.lang.Long
        )
      )(_.postTriggerCollectionDuration)
      .optionallyWith(diagnosticsMode.map(value => value.unwrap))(
        _.diagnosticsMode
      )
      .optionallyWith(spoolingMode.map(value => value.unwrap))(_.spoolingMode)
      .optionallyWith(compression.map(value => value.unwrap))(_.compression)
      .optionallyWith(priority.map(value => Priority.unwrap(value): Integer))(
        _.priority
      )
      .optionallyWith(
        signalsToCollect.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.signalsToCollect)
      .optionallyWith(collectionScheme.map(value => value.buildAwsValue()))(
        _.collectionScheme
      )
      .optionallyWith(
        dataExtraDimensions.map(value =>
          value.map { item =>
            NodePath.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dataExtraDimensions)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .optionallyWith(
        dataDestinationConfigs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataDestinationConfigs)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.GetCampaignResponse.ReadOnly =
    zio.aws.iotfleetwise.model.GetCampaignResponse.wrap(buildAwsValue())
}
object GetCampaignResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.GetCampaignResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.GetCampaignResponse =
      zio.aws.iotfleetwise.model.GetCampaignResponse(
        name.map(value => value),
        arn.map(value => value),
        description.map(value => value),
        signalCatalogArn.map(value => value),
        targetArn.map(value => value),
        status.map(value => value),
        startTime.map(value => value),
        expiryTime.map(value => value),
        postTriggerCollectionDuration.map(value => value),
        diagnosticsMode.map(value => value),
        spoolingMode.map(value => value),
        compression.map(value => value),
        priority.map(value => value),
        signalsToCollect.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        collectionScheme.map(value => value.asEditable),
        dataExtraDimensions.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value),
        dataDestinationConfigs.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Optional[CampaignName]
    def arn: Optional[Arn]
    def description: Optional[Description]
    def signalCatalogArn: Optional[Arn]
    def targetArn: Optional[Arn]
    def status: Optional[zio.aws.iotfleetwise.model.CampaignStatus]
    def startTime: Optional[Timestamp]
    def expiryTime: Optional[Timestamp]
    def postTriggerCollectionDuration: Optional[Uint32]
    def diagnosticsMode: Optional[zio.aws.iotfleetwise.model.DiagnosticsMode]
    def spoolingMode: Optional[zio.aws.iotfleetwise.model.SpoolingMode]
    def compression: Optional[zio.aws.iotfleetwise.model.Compression]
    def priority: Optional[Priority]
    def signalsToCollect
        : Optional[List[zio.aws.iotfleetwise.model.SignalInformation.ReadOnly]]
    def collectionScheme
        : Optional[zio.aws.iotfleetwise.model.CollectionScheme.ReadOnly]
    def dataExtraDimensions: Optional[List[NodePath]]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def dataDestinationConfigs: Optional[
      List[zio.aws.iotfleetwise.model.DataDestinationConfig.ReadOnly]
    ]
    def getName: ZIO[Any, AwsError, CampaignName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSignalCatalogArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("signalCatalogArn", signalCatalogArn)
    def getTargetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.CampaignStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getExpiryTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expiryTime", expiryTime)
    def getPostTriggerCollectionDuration: ZIO[Any, AwsError, Uint32] =
      AwsError.unwrapOptionField(
        "postTriggerCollectionDuration",
        postTriggerCollectionDuration
      )
    def getDiagnosticsMode
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.DiagnosticsMode] =
      AwsError.unwrapOptionField("diagnosticsMode", diagnosticsMode)
    def getSpoolingMode
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.SpoolingMode] =
      AwsError.unwrapOptionField("spoolingMode", spoolingMode)
    def getCompression
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.Compression] =
      AwsError.unwrapOptionField("compression", compression)
    def getPriority: ZIO[Any, AwsError, Priority] =
      AwsError.unwrapOptionField("priority", priority)
    def getSignalsToCollect: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.SignalInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("signalsToCollect", signalsToCollect)
    def getCollectionScheme: ZIO[
      Any,
      AwsError,
      zio.aws.iotfleetwise.model.CollectionScheme.ReadOnly
    ] = AwsError.unwrapOptionField("collectionScheme", collectionScheme)
    def getDataExtraDimensions: ZIO[Any, AwsError, List[NodePath]] =
      AwsError.unwrapOptionField("dataExtraDimensions", dataExtraDimensions)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
    def getDataDestinationConfigs: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.DataDestinationConfig.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dataDestinationConfigs",
      dataDestinationConfigs
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetCampaignResponse
  ) extends zio.aws.iotfleetwise.model.GetCampaignResponse.ReadOnly {
    override val name: Optional[CampaignName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotfleetwise.model.primitives.CampaignName(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val signalCatalogArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.signalCatalogArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val targetArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val status: Optional[zio.aws.iotfleetwise.model.CampaignStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotfleetwise.model.CampaignStatus.wrap(value))
    override val startTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.iotfleetwise.model.primitives.Timestamp(value))
    override val expiryTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expiryTime())
      .map(value => zio.aws.iotfleetwise.model.primitives.Timestamp(value))
    override val postTriggerCollectionDuration: Optional[Uint32] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postTriggerCollectionDuration())
        .map(value => zio.aws.iotfleetwise.model.primitives.Uint32(value))
    override val diagnosticsMode
        : Optional[zio.aws.iotfleetwise.model.DiagnosticsMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diagnosticsMode())
        .map(value => zio.aws.iotfleetwise.model.DiagnosticsMode.wrap(value))
    override val spoolingMode
        : Optional[zio.aws.iotfleetwise.model.SpoolingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.spoolingMode())
        .map(value => zio.aws.iotfleetwise.model.SpoolingMode.wrap(value))
    override val compression: Optional[zio.aws.iotfleetwise.model.Compression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compression())
        .map(value => zio.aws.iotfleetwise.model.Compression.wrap(value))
    override val priority: Optional[Priority] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => zio.aws.iotfleetwise.model.primitives.Priority(value))
    override val signalsToCollect: Optional[
      List[zio.aws.iotfleetwise.model.SignalInformation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.signalsToCollect())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.SignalInformation.wrap(item)
        }.toList
      )
    override val collectionScheme
        : Optional[zio.aws.iotfleetwise.model.CollectionScheme.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.collectionScheme())
        .map(value => zio.aws.iotfleetwise.model.CollectionScheme.wrap(value))
    override val dataExtraDimensions: Optional[List[NodePath]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataExtraDimensions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.primitives.NodePath(item)
          }.toList
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.iotfleetwise.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.iotfleetwise.model.primitives.Timestamp(value))
    override val dataDestinationConfigs: Optional[
      List[zio.aws.iotfleetwise.model.DataDestinationConfig.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataDestinationConfigs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.DataDestinationConfig.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetCampaignResponse
  ): zio.aws.iotfleetwise.model.GetCampaignResponse.ReadOnly = new Wrapper(impl)
}
