package zio.aws.iotfleetwise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotfleetwise.model.primitives.{Timestamp, Description, Arn}
import scala.jdk.CollectionConverters.*
final case class GetDecoderManifestResponse(
    name: String,
    arn: Arn,
    description: Optional[Description] = Optional.Absent,
    modelManifestArn: Optional[Arn] = Optional.Absent,
    status: Optional[zio.aws.iotfleetwise.model.ManifestStatus] =
      Optional.Absent,
    creationTime: Timestamp,
    lastModificationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestResponse = {
    import GetDecoderManifestResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestResponse
      .builder()
      .name(name: java.lang.String)
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        modelManifestArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.modelManifestArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModificationTime(Timestamp.unwrap(lastModificationTime): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.GetDecoderManifestResponse.ReadOnly =
    zio.aws.iotfleetwise.model.GetDecoderManifestResponse.wrap(buildAwsValue())
}
object GetDecoderManifestResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.GetDecoderManifestResponse =
      zio.aws.iotfleetwise.model.GetDecoderManifestResponse(
        name,
        arn,
        description.map(value => value),
        modelManifestArn.map(value => value),
        status.map(value => value),
        creationTime,
        lastModificationTime
      )
    def name: String
    def arn: Arn
    def description: Optional[Description]
    def modelManifestArn: Optional[Arn]
    def status: Optional[zio.aws.iotfleetwise.model.ManifestStatus]
    def creationTime: Timestamp
    def lastModificationTime: Timestamp
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getModelManifestArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("modelManifestArn", modelManifestArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.ManifestStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModificationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestResponse
  ) extends zio.aws.iotfleetwise.model.GetDecoderManifestResponse.ReadOnly {
    override val name: String = impl.name(): String
    override val arn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.arn())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val modelManifestArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelManifestArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val status: Optional[zio.aws.iotfleetwise.model.ManifestStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotfleetwise.model.ManifestStatus.wrap(value))
    override val creationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives.Timestamp(impl.creationTime())
    override val lastModificationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives
        .Timestamp(impl.lastModificationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetDecoderManifestResponse
  ): zio.aws.iotfleetwise.model.GetDecoderManifestResponse.ReadOnly =
    new Wrapper(impl)
}
