package zio.aws.iotfleetwise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotfleetwise.model.primitives.{
  Timestamp,
  Description,
  Arn,
  FleetId
}
import scala.jdk.CollectionConverters.*
final case class GetFleetResponse(
    id: FleetId,
    arn: Arn,
    description: Optional[Description] = Optional.Absent,
    signalCatalogArn: Arn,
    creationTime: Timestamp,
    lastModificationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.GetFleetResponse = {
    import GetFleetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.GetFleetResponse
      .builder()
      .id(FleetId.unwrap(id): java.lang.String)
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .signalCatalogArn(Arn.unwrap(signalCatalogArn): java.lang.String)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModificationTime(Timestamp.unwrap(lastModificationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.GetFleetResponse.ReadOnly =
    zio.aws.iotfleetwise.model.GetFleetResponse.wrap(buildAwsValue())
}
object GetFleetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.GetFleetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.GetFleetResponse =
      zio.aws.iotfleetwise.model.GetFleetResponse(
        id,
        arn,
        description.map(value => value),
        signalCatalogArn,
        creationTime,
        lastModificationTime
      )
    def id: FleetId
    def arn: Arn
    def description: Optional[Description]
    def signalCatalogArn: Arn
    def creationTime: Timestamp
    def lastModificationTime: Timestamp
    def getId: ZIO[Any, Nothing, FleetId] = ZIO.succeed(id)
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSignalCatalogArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(signalCatalogArn)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModificationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetFleetResponse
  ) extends zio.aws.iotfleetwise.model.GetFleetResponse.ReadOnly {
    override val id: FleetId =
      zio.aws.iotfleetwise.model.primitives.FleetId(impl.id())
    override val arn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.arn())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val signalCatalogArn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.signalCatalogArn())
    override val creationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives.Timestamp(impl.creationTime())
    override val lastModificationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives
        .Timestamp(impl.lastModificationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetFleetResponse
  ): zio.aws.iotfleetwise.model.GetFleetResponse.ReadOnly = new Wrapper(impl)
}
