package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetModelManifestRequest(name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestRequest = {
    import GetModelManifestRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.GetModelManifestRequest.ReadOnly =
    zio.aws.iotfleetwise.model.GetModelManifestRequest.wrap(buildAwsValue())
}
object GetModelManifestRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.GetModelManifestRequest =
      zio.aws.iotfleetwise.model.GetModelManifestRequest(name)
    def name: ResourceName
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestRequest
  ) extends zio.aws.iotfleetwise.model.GetModelManifestRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetModelManifestRequest
  ): zio.aws.iotfleetwise.model.GetModelManifestRequest.ReadOnly = new Wrapper(
    impl
  )
}
