package zio.aws.iotfleetwise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotfleetwise.model.primitives.{
  Timestamp,
  Description,
  Arn,
  ResourceName
}
import scala.jdk.CollectionConverters.*
final case class GetSignalCatalogResponse(
    name: ResourceName,
    arn: Arn,
    description: Optional[Description] = Optional.Absent,
    nodeCounts: Optional[zio.aws.iotfleetwise.model.NodeCounts] =
      Optional.Absent,
    creationTime: Timestamp,
    lastModificationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogResponse = {
    import GetSignalCatalogResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogResponse
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .arn(Arn.unwrap(arn): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(nodeCounts.map(value => value.buildAwsValue()))(
        _.nodeCounts
      )
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModificationTime(Timestamp.unwrap(lastModificationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.GetSignalCatalogResponse.ReadOnly =
    zio.aws.iotfleetwise.model.GetSignalCatalogResponse.wrap(buildAwsValue())
}
object GetSignalCatalogResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.GetSignalCatalogResponse =
      zio.aws.iotfleetwise.model.GetSignalCatalogResponse(
        name,
        arn,
        description.map(value => value),
        nodeCounts.map(value => value.asEditable),
        creationTime,
        lastModificationTime
      )
    def name: ResourceName
    def arn: Arn
    def description: Optional[Description]
    def nodeCounts: Optional[zio.aws.iotfleetwise.model.NodeCounts.ReadOnly]
    def creationTime: Timestamp
    def lastModificationTime: Timestamp
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNodeCounts
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.NodeCounts.ReadOnly] =
      AwsError.unwrapOptionField("nodeCounts", nodeCounts)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModificationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogResponse
  ) extends zio.aws.iotfleetwise.model.GetSignalCatalogResponse.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val arn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.arn())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val nodeCounts
        : Optional[zio.aws.iotfleetwise.model.NodeCounts.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeCounts())
        .map(value => zio.aws.iotfleetwise.model.NodeCounts.wrap(value))
    override val creationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives.Timestamp(impl.creationTime())
    override val lastModificationTime: Timestamp =
      zio.aws.iotfleetwise.model.primitives
        .Timestamp(impl.lastModificationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetSignalCatalogResponse
  ): zio.aws.iotfleetwise.model.GetSignalCatalogResponse.ReadOnly = new Wrapper(
    impl
  )
}
