package zio.aws.iotfleetwise.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotfleetwise.model.primitives.{
  AttributeName,
  Timestamp,
  Arn,
  VehicleName,
  AttributeValue
}
import scala.jdk.CollectionConverters.*
final case class GetVehicleResponse(
    vehicleName: Optional[VehicleName] = Optional.Absent,
    arn: Optional[Arn] = Optional.Absent,
    modelManifestArn: Optional[Arn] = Optional.Absent,
    decoderManifestArn: Optional[Arn] = Optional.Absent,
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModificationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.GetVehicleResponse = {
    import GetVehicleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.GetVehicleResponse
      .builder()
      .optionallyWith(
        vehicleName.map(value => VehicleName.unwrap(value): java.lang.String)
      )(_.vehicleName)
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(
        modelManifestArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.modelManifestArn)
      .optionallyWith(
        decoderManifestArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.decoderManifestArn)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModificationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModificationTime)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.GetVehicleResponse.ReadOnly =
    zio.aws.iotfleetwise.model.GetVehicleResponse.wrap(buildAwsValue())
}
object GetVehicleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.GetVehicleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.GetVehicleResponse =
      zio.aws.iotfleetwise.model.GetVehicleResponse(
        vehicleName.map(value => value),
        arn.map(value => value),
        modelManifestArn.map(value => value),
        decoderManifestArn.map(value => value),
        attributes.map(value => value),
        creationTime.map(value => value),
        lastModificationTime.map(value => value)
      )
    def vehicleName: Optional[VehicleName]
    def arn: Optional[Arn]
    def modelManifestArn: Optional[Arn]
    def decoderManifestArn: Optional[Arn]
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def creationTime: Optional[Timestamp]
    def lastModificationTime: Optional[Timestamp]
    def getVehicleName: ZIO[Any, AwsError, VehicleName] =
      AwsError.unwrapOptionField("vehicleName", vehicleName)
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getModelManifestArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("modelManifestArn", modelManifestArn)
    def getDecoderManifestArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("decoderManifestArn", decoderManifestArn)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModificationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModificationTime", lastModificationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetVehicleResponse
  ) extends zio.aws.iotfleetwise.model.GetVehicleResponse.ReadOnly {
    override val vehicleName: Optional[VehicleName] = zio.aws.core.internal
      .optionalFromNullable(impl.vehicleName())
      .map(value => zio.aws.iotfleetwise.model.primitives.VehicleName(value))
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val modelManifestArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelManifestArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val decoderManifestArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.decoderManifestArn())
      .map(value => zio.aws.iotfleetwise.model.primitives.Arn(value))
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iotfleetwise.model.primitives.AttributeName(
                key
              ) -> zio.aws.iotfleetwise.model.primitives.AttributeValue(value)
            })
            .toMap
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.iotfleetwise.model.primitives.Timestamp(value))
    override val lastModificationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModificationTime())
        .map(value => zio.aws.iotfleetwise.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetVehicleResponse
  ): zio.aws.iotfleetwise.model.GetVehicleResponse.ReadOnly = new Wrapper(impl)
}
