package zio.aws.iotfleetwise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.{
  VehicleName,
  MaxResults,
  NextToken
}
import scala.jdk.CollectionConverters.*
final case class GetVehicleStatusRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    vehicleName: VehicleName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest = {
    import GetVehicleStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .vehicleName(VehicleName.unwrap(vehicleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.GetVehicleStatusRequest.ReadOnly =
    zio.aws.iotfleetwise.model.GetVehicleStatusRequest.wrap(buildAwsValue())
}
object GetVehicleStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.GetVehicleStatusRequest =
      zio.aws.iotfleetwise.model.GetVehicleStatusRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        vehicleName
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def vehicleName: VehicleName
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getVehicleName: ZIO[Any, Nothing, VehicleName] =
      ZIO.succeed(vehicleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest
  ) extends zio.aws.iotfleetwise.model.GetVehicleStatusRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotfleetwise.model.primitives.MaxResults(value))
    override val vehicleName: VehicleName =
      zio.aws.iotfleetwise.model.primitives.VehicleName(impl.vehicleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest
  ): zio.aws.iotfleetwise.model.GetVehicleStatusRequest.ReadOnly = new Wrapper(
    impl
  )
}
