package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetVehicleStatusResponse(
    campaigns: Optional[Iterable[zio.aws.iotfleetwise.model.VehicleStatus]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse = {
    import GetVehicleStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse
      .builder()
      .optionallyWith(
        campaigns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.campaigns)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.GetVehicleStatusResponse.ReadOnly =
    zio.aws.iotfleetwise.model.GetVehicleStatusResponse.wrap(buildAwsValue())
}
object GetVehicleStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.GetVehicleStatusResponse =
      zio.aws.iotfleetwise.model.GetVehicleStatusResponse(
        campaigns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def campaigns
        : Optional[List[zio.aws.iotfleetwise.model.VehicleStatus.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getCampaigns: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.VehicleStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("campaigns", campaigns)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse
  ) extends zio.aws.iotfleetwise.model.GetVehicleStatusResponse.ReadOnly {
    override val campaigns
        : Optional[List[zio.aws.iotfleetwise.model.VehicleStatus.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.campaigns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.VehicleStatus.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse
  ): zio.aws.iotfleetwise.model.GetVehicleStatusResponse.ReadOnly = new Wrapper(
    impl
  )
}
