package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{ErrorMessage, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IamRegistrationResponse(
    roleArn: Arn,
    registrationStatus: zio.aws.iotfleetwise.model.RegistrationStatus,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.IamRegistrationResponse = {
    import IamRegistrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.IamRegistrationResponse
      .builder()
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .registrationStatus(registrationStatus.unwrap)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.IamRegistrationResponse.ReadOnly =
    zio.aws.iotfleetwise.model.IamRegistrationResponse.wrap(buildAwsValue())
}
object IamRegistrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.IamRegistrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.IamRegistrationResponse =
      zio.aws.iotfleetwise.model.IamRegistrationResponse(
        roleArn,
        registrationStatus,
        errorMessage.map(value => value)
      )
    def roleArn: Arn
    def registrationStatus: zio.aws.iotfleetwise.model.RegistrationStatus
    def errorMessage: Optional[ErrorMessage]
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getRegistrationStatus
        : ZIO[Any, Nothing, zio.aws.iotfleetwise.model.RegistrationStatus] =
      ZIO.succeed(registrationStatus)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.IamRegistrationResponse
  ) extends zio.aws.iotfleetwise.model.IamRegistrationResponse.ReadOnly {
    override val roleArn: Arn =
      zio.aws.iotfleetwise.model.primitives.Arn(impl.roleArn())
    override val registrationStatus
        : zio.aws.iotfleetwise.model.RegistrationStatus =
      zio.aws.iotfleetwise.model.RegistrationStatus
        .wrap(impl.registrationStatus())
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.iotfleetwise.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.IamRegistrationResponse
  ): zio.aws.iotfleetwise.model.IamRegistrationResponse.ReadOnly = new Wrapper(
    impl
  )
}
