package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.IAMRoleArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class IamResources(roleArn: IAMRoleArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.IamResources = {
    import IamResources.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.IamResources
      .builder()
      .roleArn(IAMRoleArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.IamResources.ReadOnly =
    zio.aws.iotfleetwise.model.IamResources.wrap(buildAwsValue())
}
object IamResources {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.IamResources
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.IamResources =
      zio.aws.iotfleetwise.model.IamResources(roleArn)
    def roleArn: IAMRoleArn
    def getRoleArn: ZIO[Any, Nothing, IAMRoleArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.IamResources
  ) extends zio.aws.iotfleetwise.model.IamResources.ReadOnly {
    override val roleArn: IAMRoleArn =
      zio.aws.iotfleetwise.model.primitives.IAMRoleArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.IamResources
  ): zio.aws.iotfleetwise.model.IamResources.ReadOnly = new Wrapper(impl)
}
