package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Description, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportSignalCatalogRequest(
    name: ResourceName,
    description: Optional[Description] = Optional.Absent,
    vss: Optional[zio.aws.iotfleetwise.model.FormattedVss] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.iotfleetwise.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogRequest = {
    import ImportSignalCatalogRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(vss.map(value => value.buildAwsValue()))(_.vss)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ImportSignalCatalogRequest.ReadOnly =
    zio.aws.iotfleetwise.model.ImportSignalCatalogRequest.wrap(buildAwsValue())
}
object ImportSignalCatalogRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ImportSignalCatalogRequest =
      zio.aws.iotfleetwise.model.ImportSignalCatalogRequest(
        name,
        description.map(value => value),
        vss.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: ResourceName
    def description: Optional[Description]
    def vss: Optional[zio.aws.iotfleetwise.model.FormattedVss.ReadOnly]
    def tags: Optional[List[zio.aws.iotfleetwise.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getVss
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.FormattedVss.ReadOnly] =
      AwsError.unwrapOptionField("vss", vss)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotfleetwise.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogRequest
  ) extends zio.aws.iotfleetwise.model.ImportSignalCatalogRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val vss
        : Optional[zio.aws.iotfleetwise.model.FormattedVss.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vss())
        .map(value => zio.aws.iotfleetwise.model.FormattedVss.wrap(value))
    override val tags: Optional[List[zio.aws.iotfleetwise.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ImportSignalCatalogRequest
  ): zio.aws.iotfleetwise.model.ImportSignalCatalogRequest.ReadOnly =
    new Wrapper(impl)
}
