package zio.aws.iotfleetwise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.{Status, MaxResults, NextToken}
import scala.jdk.CollectionConverters.*
final case class ListCampaignsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    status: Optional[Status] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest = {
    import ListCampaignsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.ListCampaignsRequest.ReadOnly =
    zio.aws.iotfleetwise.model.ListCampaignsRequest.wrap(buildAwsValue())
}
object ListCampaignsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListCampaignsRequest =
      zio.aws.iotfleetwise.model.ListCampaignsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        status.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def status: Optional[Status]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest
  ) extends zio.aws.iotfleetwise.model.ListCampaignsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotfleetwise.model.primitives.MaxResults(value))
    override val status: Optional[Status] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.iotfleetwise.model.primitives.Status(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListCampaignsRequest
  ): zio.aws.iotfleetwise.model.ListCampaignsRequest.ReadOnly = new Wrapper(
    impl
  )
}
