package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDecoderManifestSignalsResponse(
    signalDecoders: Optional[
      Iterable[zio.aws.iotfleetwise.model.SignalDecoder]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse = {
    import ListDecoderManifestSignalsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse
      .builder()
      .optionallyWith(
        signalDecoders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.signalDecoders)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ListDecoderManifestSignalsResponse.ReadOnly =
    zio.aws.iotfleetwise.model.ListDecoderManifestSignalsResponse
      .wrap(buildAwsValue())
}
object ListDecoderManifestSignalsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotfleetwise.model.ListDecoderManifestSignalsResponse =
      zio.aws.iotfleetwise.model.ListDecoderManifestSignalsResponse(
        signalDecoders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def signalDecoders
        : Optional[List[zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSignalDecoders: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly
    ]] = AwsError.unwrapOptionField("signalDecoders", signalDecoders)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse
  ) extends zio.aws.iotfleetwise.model.ListDecoderManifestSignalsResponse.ReadOnly {
    override val signalDecoders
        : Optional[List[zio.aws.iotfleetwise.model.SignalDecoder.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signalDecoders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.SignalDecoder.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestSignalsResponse
  ): zio.aws.iotfleetwise.model.ListDecoderManifestSignalsResponse.ReadOnly =
    new Wrapper(impl)
}
