package zio.aws.iotfleetwise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.{
  MaxResults,
  NextToken,
  VehicleName
}
import scala.jdk.CollectionConverters.*
final case class ListFleetsForVehicleRequest(
    vehicleName: VehicleName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest = {
    import ListFleetsForVehicleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest
      .builder()
      .vehicleName(VehicleName.unwrap(vehicleName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ListFleetsForVehicleRequest.ReadOnly =
    zio.aws.iotfleetwise.model.ListFleetsForVehicleRequest.wrap(buildAwsValue())
}
object ListFleetsForVehicleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListFleetsForVehicleRequest =
      zio.aws.iotfleetwise.model.ListFleetsForVehicleRequest(
        vehicleName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def vehicleName: VehicleName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getVehicleName: ZIO[Any, Nothing, VehicleName] =
      ZIO.succeed(vehicleName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest
  ) extends zio.aws.iotfleetwise.model.ListFleetsForVehicleRequest.ReadOnly {
    override val vehicleName: VehicleName =
      zio.aws.iotfleetwise.model.primitives.VehicleName(impl.vehicleName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotfleetwise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest
  ): zio.aws.iotfleetwise.model.ListFleetsForVehicleRequest.ReadOnly =
    new Wrapper(impl)
}
