package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{NextToken, FleetId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFleetsForVehicleResponse(
    fleets: Optional[Iterable[FleetId]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse = {
    import ListFleetsForVehicleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse
      .builder()
      .optionallyWith(
        fleets.map(value =>
          value.map { item =>
            FleetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.fleets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ListFleetsForVehicleResponse.ReadOnly =
    zio.aws.iotfleetwise.model.ListFleetsForVehicleResponse
      .wrap(buildAwsValue())
}
object ListFleetsForVehicleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListFleetsForVehicleResponse =
      zio.aws.iotfleetwise.model.ListFleetsForVehicleResponse(
        fleets.map(value => value),
        nextToken.map(value => value)
      )
    def fleets: Optional[List[FleetId]]
    def nextToken: Optional[NextToken]
    def getFleets: ZIO[Any, AwsError, List[FleetId]] =
      AwsError.unwrapOptionField("fleets", fleets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse
  ) extends zio.aws.iotfleetwise.model.ListFleetsForVehicleResponse.ReadOnly {
    override val fleets: Optional[List[FleetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.fleets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.primitives.FleetId(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse
  ): zio.aws.iotfleetwise.model.ListFleetsForVehicleResponse.ReadOnly =
    new Wrapper(impl)
}
