package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListFleetsResponse(
    fleetSummaries: Optional[
      Iterable[zio.aws.iotfleetwise.model.FleetSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse = {
    import ListFleetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse
      .builder()
      .optionallyWith(
        fleetSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fleetSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.ListFleetsResponse.ReadOnly =
    zio.aws.iotfleetwise.model.ListFleetsResponse.wrap(buildAwsValue())
}
object ListFleetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListFleetsResponse =
      zio.aws.iotfleetwise.model.ListFleetsResponse(
        fleetSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def fleetSummaries
        : Optional[List[zio.aws.iotfleetwise.model.FleetSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getFleetSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.FleetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("fleetSummaries", fleetSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse
  ) extends zio.aws.iotfleetwise.model.ListFleetsResponse.ReadOnly {
    override val fleetSummaries
        : Optional[List[zio.aws.iotfleetwise.model.FleetSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fleetSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotfleetwise.model.FleetSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListFleetsResponse
  ): zio.aws.iotfleetwise.model.ListFleetsResponse.ReadOnly = new Wrapper(impl)
}
