package zio.aws.iotfleetwise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.{
  MaxResults,
  NextToken,
  ResourceName
}
import scala.jdk.CollectionConverters.*
final case class ListModelManifestNodesRequest(
    name: ResourceName,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest = {
    import ListModelManifestNodesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ListModelManifestNodesRequest.ReadOnly =
    zio.aws.iotfleetwise.model.ListModelManifestNodesRequest
      .wrap(buildAwsValue())
}
object ListModelManifestNodesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListModelManifestNodesRequest =
      zio.aws.iotfleetwise.model.ListModelManifestNodesRequest(
        name,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def name: ResourceName
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest
  ) extends zio.aws.iotfleetwise.model.ListModelManifestNodesRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.iotfleetwise.model.primitives.ResourceName(impl.name())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iotfleetwise.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestNodesRequest
  ): zio.aws.iotfleetwise.model.ListModelManifestNodesRequest.ReadOnly =
    new Wrapper(impl)
}
