package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListSignalCatalogsResponse(
    summaries: Optional[
      Iterable[zio.aws.iotfleetwise.model.SignalCatalogSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse = {
    import ListSignalCatalogsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse
      .builder()
      .optionallyWith(
        summaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.iotfleetwise.model.ListSignalCatalogsResponse.ReadOnly =
    zio.aws.iotfleetwise.model.ListSignalCatalogsResponse.wrap(buildAwsValue())
}
object ListSignalCatalogsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ListSignalCatalogsResponse =
      zio.aws.iotfleetwise.model.ListSignalCatalogsResponse(
        summaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def summaries: Optional[
      List[zio.aws.iotfleetwise.model.SignalCatalogSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotfleetwise.model.SignalCatalogSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("summaries", summaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse
  ) extends zio.aws.iotfleetwise.model.ListSignalCatalogsResponse.ReadOnly {
    override val summaries: Optional[
      List[zio.aws.iotfleetwise.model.SignalCatalogSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.summaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotfleetwise.model.SignalCatalogSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iotfleetwise.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ListSignalCatalogsResponse
  ): zio.aws.iotfleetwise.model.ListSignalCatalogsResponse.ReadOnly =
    new Wrapper(impl)
}
