package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.InterfaceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetworkInterface(
    interfaceId: InterfaceId,
    `type`: zio.aws.iotfleetwise.model.NetworkInterfaceType,
    canInterface: Optional[zio.aws.iotfleetwise.model.CanInterface] =
      Optional.Absent,
    obdInterface: Optional[zio.aws.iotfleetwise.model.ObdInterface] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface = {
    import NetworkInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface
      .builder()
      .interfaceId(InterfaceId.unwrap(interfaceId): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(canInterface.map(value => value.buildAwsValue()))(
        _.canInterface
      )
      .optionallyWith(obdInterface.map(value => value.buildAwsValue()))(
        _.obdInterface
      )
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly =
    zio.aws.iotfleetwise.model.NetworkInterface.wrap(buildAwsValue())
}
object NetworkInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.NetworkInterface =
      zio.aws.iotfleetwise.model.NetworkInterface(
        interfaceId,
        `type`,
        canInterface.map(value => value.asEditable),
        obdInterface.map(value => value.asEditable)
      )
    def interfaceId: InterfaceId
    def `type`: zio.aws.iotfleetwise.model.NetworkInterfaceType
    def canInterface: Optional[zio.aws.iotfleetwise.model.CanInterface.ReadOnly]
    def obdInterface: Optional[zio.aws.iotfleetwise.model.ObdInterface.ReadOnly]
    def getInterfaceId: ZIO[Any, Nothing, InterfaceId] =
      ZIO.succeed(interfaceId)
    def getType
        : ZIO[Any, Nothing, zio.aws.iotfleetwise.model.NetworkInterfaceType] =
      ZIO.succeed(`type`)
    def getCanInterface
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.CanInterface.ReadOnly] =
      AwsError.unwrapOptionField("canInterface", canInterface)
    def getObdInterface
        : ZIO[Any, AwsError, zio.aws.iotfleetwise.model.ObdInterface.ReadOnly] =
      AwsError.unwrapOptionField("obdInterface", obdInterface)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface
  ) extends zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly {
    override val interfaceId: InterfaceId =
      zio.aws.iotfleetwise.model.primitives.InterfaceId(impl.interfaceId())
    override val `type`: zio.aws.iotfleetwise.model.NetworkInterfaceType =
      zio.aws.iotfleetwise.model.NetworkInterfaceType.wrap(impl.`type`())
    override val canInterface
        : Optional[zio.aws.iotfleetwise.model.CanInterface.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canInterface())
        .map(value => zio.aws.iotfleetwise.model.CanInterface.wrap(value))
    override val obdInterface
        : Optional[zio.aws.iotfleetwise.model.ObdInterface.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.obdInterface())
        .map(value => zio.aws.iotfleetwise.model.ObdInterface.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface
  ): zio.aws.iotfleetwise.model.NetworkInterface.ReadOnly = new Wrapper(impl)
}
