package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters.*
sealed trait NetworkInterfaceType {
  def unwrap
      : software.amazon.awssdk.services.iotfleetwise.model.NetworkInterfaceType
}
object NetworkInterfaceType {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.NetworkInterfaceType
  ): zio.aws.iotfleetwise.model.NetworkInterfaceType = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.NetworkInterfaceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NetworkInterfaceType.CAN_INTERFACE =>
      val r = CAN_INTERFACE
      r
    case software.amazon.awssdk.services.iotfleetwise.model.NetworkInterfaceType.OBD_INTERFACE =>
      val r = OBD_INTERFACE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleetwise.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NetworkInterfaceType =
      software.amazon.awssdk.services.iotfleetwise.model.NetworkInterfaceType.UNKNOWN_TO_SDK_VERSION
  }
  case object CAN_INTERFACE
      extends zio.aws.iotfleetwise.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NetworkInterfaceType =
      software.amazon.awssdk.services.iotfleetwise.model.NetworkInterfaceType.CAN_INTERFACE
  }
  case object OBD_INTERFACE
      extends zio.aws.iotfleetwise.model.NetworkInterfaceType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.NetworkInterfaceType =
      software.amazon.awssdk.services.iotfleetwise.model.NetworkInterfaceType.OBD_INTERFACE
  }
}
