package zio.aws.iotfleetwise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.Number
import scala.jdk.CollectionConverters.*
final case class NodeCounts(
    totalNodes: Optional[Number] = Optional.Absent,
    totalBranches: Optional[Number] = Optional.Absent,
    totalSensors: Optional[Number] = Optional.Absent,
    totalAttributes: Optional[Number] = Optional.Absent,
    totalActuators: Optional[Number] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.NodeCounts = {
    import NodeCounts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.NodeCounts
      .builder()
      .optionallyWith(totalNodes.map(value => Number.unwrap(value): Integer))(
        _.totalNodes
      )
      .optionallyWith(
        totalBranches.map(value => Number.unwrap(value): Integer)
      )(_.totalBranches)
      .optionallyWith(totalSensors.map(value => Number.unwrap(value): Integer))(
        _.totalSensors
      )
      .optionallyWith(
        totalAttributes.map(value => Number.unwrap(value): Integer)
      )(_.totalAttributes)
      .optionallyWith(
        totalActuators.map(value => Number.unwrap(value): Integer)
      )(_.totalActuators)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.NodeCounts.ReadOnly =
    zio.aws.iotfleetwise.model.NodeCounts.wrap(buildAwsValue())
}
object NodeCounts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.NodeCounts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.NodeCounts =
      zio.aws.iotfleetwise.model.NodeCounts(
        totalNodes.map(value => value),
        totalBranches.map(value => value),
        totalSensors.map(value => value),
        totalAttributes.map(value => value),
        totalActuators.map(value => value)
      )
    def totalNodes: Optional[Number]
    def totalBranches: Optional[Number]
    def totalSensors: Optional[Number]
    def totalAttributes: Optional[Number]
    def totalActuators: Optional[Number]
    def getTotalNodes: ZIO[Any, AwsError, Number] =
      AwsError.unwrapOptionField("totalNodes", totalNodes)
    def getTotalBranches: ZIO[Any, AwsError, Number] =
      AwsError.unwrapOptionField("totalBranches", totalBranches)
    def getTotalSensors: ZIO[Any, AwsError, Number] =
      AwsError.unwrapOptionField("totalSensors", totalSensors)
    def getTotalAttributes: ZIO[Any, AwsError, Number] =
      AwsError.unwrapOptionField("totalAttributes", totalAttributes)
    def getTotalActuators: ZIO[Any, AwsError, Number] =
      AwsError.unwrapOptionField("totalActuators", totalActuators)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.NodeCounts
  ) extends zio.aws.iotfleetwise.model.NodeCounts.ReadOnly {
    override val totalNodes: Optional[Number] = zio.aws.core.internal
      .optionalFromNullable(impl.totalNodes())
      .map(value => zio.aws.iotfleetwise.model.primitives.Number(value))
    override val totalBranches: Optional[Number] = zio.aws.core.internal
      .optionalFromNullable(impl.totalBranches())
      .map(value => zio.aws.iotfleetwise.model.primitives.Number(value))
    override val totalSensors: Optional[Number] = zio.aws.core.internal
      .optionalFromNullable(impl.totalSensors())
      .map(value => zio.aws.iotfleetwise.model.primitives.Number(value))
    override val totalAttributes: Optional[Number] = zio.aws.core.internal
      .optionalFromNullable(impl.totalAttributes())
      .map(value => zio.aws.iotfleetwise.model.primitives.Number(value))
    override val totalActuators: Optional[Number] = zio.aws.core.internal
      .optionalFromNullable(impl.totalActuators())
      .map(value => zio.aws.iotfleetwise.model.primitives.Number(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.NodeCounts
  ): zio.aws.iotfleetwise.model.NodeCounts.ReadOnly = new Wrapper(impl)
}
