package zio.aws.iotfleetwise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.{
  ObdStandard,
  NonNegativeInteger,
  ObdInterfaceName
}
import scala.jdk.CollectionConverters.*
final case class ObdInterface(
    name: ObdInterfaceName,
    requestMessageId: NonNegativeInteger,
    obdStandard: Optional[ObdStandard] = Optional.Absent,
    pidRequestIntervalSeconds: Optional[NonNegativeInteger] = Optional.Absent,
    dtcRequestIntervalSeconds: Optional[NonNegativeInteger] = Optional.Absent,
    useExtendedIds: Optional[Boolean] = Optional.Absent,
    hasTransmissionEcu: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ObdInterface = {
    import ObdInterface.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ObdInterface
      .builder()
      .name(ObdInterfaceName.unwrap(name): java.lang.String)
      .requestMessageId(NonNegativeInteger.unwrap(requestMessageId): Integer)
      .optionallyWith(
        obdStandard.map(value => ObdStandard.unwrap(value): java.lang.String)
      )(_.obdStandard)
      .optionallyWith(
        pidRequestIntervalSeconds.map(value =>
          NonNegativeInteger.unwrap(value): Integer
        )
      )(_.pidRequestIntervalSeconds)
      .optionallyWith(
        dtcRequestIntervalSeconds.map(value =>
          NonNegativeInteger.unwrap(value): Integer
        )
      )(_.dtcRequestIntervalSeconds)
      .optionallyWith(useExtendedIds.map(value => value: java.lang.Boolean))(
        _.useExtendedIds
      )
      .optionallyWith(
        hasTransmissionEcu.map(value => value: java.lang.Boolean)
      )(_.hasTransmissionEcu)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.ObdInterface.ReadOnly =
    zio.aws.iotfleetwise.model.ObdInterface.wrap(buildAwsValue())
}
object ObdInterface {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ObdInterface
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ObdInterface =
      zio.aws.iotfleetwise.model.ObdInterface(
        name,
        requestMessageId,
        obdStandard.map(value => value),
        pidRequestIntervalSeconds.map(value => value),
        dtcRequestIntervalSeconds.map(value => value),
        useExtendedIds.map(value => value),
        hasTransmissionEcu.map(value => value)
      )
    def name: ObdInterfaceName
    def requestMessageId: NonNegativeInteger
    def obdStandard: Optional[ObdStandard]
    def pidRequestIntervalSeconds: Optional[NonNegativeInteger]
    def dtcRequestIntervalSeconds: Optional[NonNegativeInteger]
    def useExtendedIds: Optional[Boolean]
    def hasTransmissionEcu: Optional[Boolean]
    def getName: ZIO[Any, Nothing, ObdInterfaceName] = ZIO.succeed(name)
    def getRequestMessageId: ZIO[Any, Nothing, NonNegativeInteger] =
      ZIO.succeed(requestMessageId)
    def getObdStandard: ZIO[Any, AwsError, ObdStandard] =
      AwsError.unwrapOptionField("obdStandard", obdStandard)
    def getPidRequestIntervalSeconds: ZIO[Any, AwsError, NonNegativeInteger] =
      AwsError.unwrapOptionField(
        "pidRequestIntervalSeconds",
        pidRequestIntervalSeconds
      )
    def getDtcRequestIntervalSeconds: ZIO[Any, AwsError, NonNegativeInteger] =
      AwsError.unwrapOptionField(
        "dtcRequestIntervalSeconds",
        dtcRequestIntervalSeconds
      )
    def getUseExtendedIds: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useExtendedIds", useExtendedIds)
    def getHasTransmissionEcu: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("hasTransmissionEcu", hasTransmissionEcu)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ObdInterface
  ) extends zio.aws.iotfleetwise.model.ObdInterface.ReadOnly {
    override val name: ObdInterfaceName =
      zio.aws.iotfleetwise.model.primitives.ObdInterfaceName(impl.name())
    override val requestMessageId: NonNegativeInteger =
      zio.aws.iotfleetwise.model.primitives
        .NonNegativeInteger(impl.requestMessageId())
    override val obdStandard: Optional[ObdStandard] = zio.aws.core.internal
      .optionalFromNullable(impl.obdStandard())
      .map(value => zio.aws.iotfleetwise.model.primitives.ObdStandard(value))
    override val pidRequestIntervalSeconds: Optional[NonNegativeInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pidRequestIntervalSeconds())
        .map(value =>
          zio.aws.iotfleetwise.model.primitives.NonNegativeInteger(value)
        )
    override val dtcRequestIntervalSeconds: Optional[NonNegativeInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dtcRequestIntervalSeconds())
        .map(value =>
          zio.aws.iotfleetwise.model.primitives.NonNegativeInteger(value)
        )
    override val useExtendedIds: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.useExtendedIds())
      .map(value => value: Boolean)
    override val hasTransmissionEcu: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hasTransmissionEcu())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ObdInterface
  ): zio.aws.iotfleetwise.model.ObdInterface.ReadOnly = new Wrapper(impl)
}
