package zio.aws.iotfleetwise.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.iotfleetwise.model.primitives.{
  ObdBitmaskLength,
  ObdByteLength,
  NonNegativeInteger,
  PositiveInteger
}
import scala.jdk.CollectionConverters.*
final case class ObdSignal(
    pidResponseLength: PositiveInteger,
    serviceMode: NonNegativeInteger,
    pid: NonNegativeInteger,
    scaling: Double,
    offset: Double,
    startByte: NonNegativeInteger,
    byteLength: ObdByteLength,
    bitRightShift: Optional[NonNegativeInteger] = Optional.Absent,
    bitMaskLength: Optional[ObdBitmaskLength] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.ObdSignal = {
    import ObdSignal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.ObdSignal
      .builder()
      .pidResponseLength(PositiveInteger.unwrap(pidResponseLength): Integer)
      .serviceMode(NonNegativeInteger.unwrap(serviceMode): Integer)
      .pid(NonNegativeInteger.unwrap(pid): Integer)
      .scaling(scaling: java.lang.Double)
      .offset(offset: java.lang.Double)
      .startByte(NonNegativeInteger.unwrap(startByte): Integer)
      .byteLength(ObdByteLength.unwrap(byteLength): Integer)
      .optionallyWith(
        bitRightShift.map(value => NonNegativeInteger.unwrap(value): Integer)
      )(_.bitRightShift)
      .optionallyWith(
        bitMaskLength.map(value => ObdBitmaskLength.unwrap(value): Integer)
      )(_.bitMaskLength)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.ObdSignal.ReadOnly =
    zio.aws.iotfleetwise.model.ObdSignal.wrap(buildAwsValue())
}
object ObdSignal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.ObdSignal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.ObdSignal =
      zio.aws.iotfleetwise.model.ObdSignal(
        pidResponseLength,
        serviceMode,
        pid,
        scaling,
        offset,
        startByte,
        byteLength,
        bitRightShift.map(value => value),
        bitMaskLength.map(value => value)
      )
    def pidResponseLength: PositiveInteger
    def serviceMode: NonNegativeInteger
    def pid: NonNegativeInteger
    def scaling: Double
    def offset: Double
    def startByte: NonNegativeInteger
    def byteLength: ObdByteLength
    def bitRightShift: Optional[NonNegativeInteger]
    def bitMaskLength: Optional[ObdBitmaskLength]
    def getPidResponseLength: ZIO[Any, Nothing, PositiveInteger] =
      ZIO.succeed(pidResponseLength)
    def getServiceMode: ZIO[Any, Nothing, NonNegativeInteger] =
      ZIO.succeed(serviceMode)
    def getPid: ZIO[Any, Nothing, NonNegativeInteger] = ZIO.succeed(pid)
    def getScaling: ZIO[Any, Nothing, Double] = ZIO.succeed(scaling)
    def getOffset: ZIO[Any, Nothing, Double] = ZIO.succeed(offset)
    def getStartByte: ZIO[Any, Nothing, NonNegativeInteger] =
      ZIO.succeed(startByte)
    def getByteLength: ZIO[Any, Nothing, ObdByteLength] =
      ZIO.succeed(byteLength)
    def getBitRightShift: ZIO[Any, AwsError, NonNegativeInteger] =
      AwsError.unwrapOptionField("bitRightShift", bitRightShift)
    def getBitMaskLength: ZIO[Any, AwsError, ObdBitmaskLength] =
      AwsError.unwrapOptionField("bitMaskLength", bitMaskLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ObdSignal
  ) extends zio.aws.iotfleetwise.model.ObdSignal.ReadOnly {
    override val pidResponseLength: PositiveInteger =
      zio.aws.iotfleetwise.model.primitives
        .PositiveInteger(impl.pidResponseLength())
    override val serviceMode: NonNegativeInteger =
      zio.aws.iotfleetwise.model.primitives
        .NonNegativeInteger(impl.serviceMode())
    override val pid: NonNegativeInteger =
      zio.aws.iotfleetwise.model.primitives.NonNegativeInteger(impl.pid())
    override val scaling: Double = impl.scaling(): Double
    override val offset: Double = impl.offset(): Double
    override val startByte: NonNegativeInteger =
      zio.aws.iotfleetwise.model.primitives.NonNegativeInteger(impl.startByte())
    override val byteLength: ObdByteLength =
      zio.aws.iotfleetwise.model.primitives.ObdByteLength(impl.byteLength())
    override val bitRightShift: Optional[NonNegativeInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bitRightShift())
        .map(value =>
          zio.aws.iotfleetwise.model.primitives.NonNegativeInteger(value)
        )
    override val bitMaskLength: Optional[ObdBitmaskLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bitMaskLength())
        .map(value =>
          zio.aws.iotfleetwise.model.primitives.ObdBitmaskLength(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.ObdSignal
  ): zio.aws.iotfleetwise.model.ObdSignal.ReadOnly = new Wrapper(impl)
}
