package zio.aws.iotfleetwise.model
import zio.aws.iotfleetwise.model.primitives.{Message, Description}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Sensor(
    fullyQualifiedName: String,
    dataType: zio.aws.iotfleetwise.model.NodeDataType,
    description: Optional[Description] = Optional.Absent,
    unit: Optional[String] = Optional.Absent,
    allowedValues: Optional[Iterable[String]] = Optional.Absent,
    min: Optional[Double] = Optional.Absent,
    max: Optional[Double] = Optional.Absent,
    deprecationMessage: Optional[Message] = Optional.Absent,
    comment: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotfleetwise.model.Sensor = {
    import Sensor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotfleetwise.model.Sensor
      .builder()
      .fullyQualifiedName(fullyQualifiedName: java.lang.String)
      .dataType(dataType.unwrap)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(unit.map(value => value: java.lang.String))(_.unit)
      .optionallyWith(
        allowedValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.allowedValues)
      .optionallyWith(min.map(value => value: java.lang.Double))(_.min)
      .optionallyWith(max.map(value => value: java.lang.Double))(_.max)
      .optionallyWith(
        deprecationMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.deprecationMessage)
      .optionallyWith(
        comment.map(value => Message.unwrap(value): java.lang.String)
      )(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.iotfleetwise.model.Sensor.ReadOnly =
    zio.aws.iotfleetwise.model.Sensor.wrap(buildAwsValue())
}
object Sensor {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotfleetwise.model.Sensor
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotfleetwise.model.Sensor =
      zio.aws.iotfleetwise.model.Sensor(
        fullyQualifiedName,
        dataType,
        description.map(value => value),
        unit.map(value => value),
        allowedValues.map(value => value),
        min.map(value => value),
        max.map(value => value),
        deprecationMessage.map(value => value),
        comment.map(value => value)
      )
    def fullyQualifiedName: String
    def dataType: zio.aws.iotfleetwise.model.NodeDataType
    def description: Optional[Description]
    def unit: Optional[String]
    def allowedValues: Optional[List[String]]
    def min: Optional[Double]
    def max: Optional[Double]
    def deprecationMessage: Optional[Message]
    def comment: Optional[Message]
    def getFullyQualifiedName: ZIO[Any, Nothing, String] =
      ZIO.succeed(fullyQualifiedName)
    def getDataType
        : ZIO[Any, Nothing, zio.aws.iotfleetwise.model.NodeDataType] =
      ZIO.succeed(dataType)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getUnit: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("unit", unit)
    def getAllowedValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getMin: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("min", min)
    def getMax: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("max", max)
    def getDeprecationMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("deprecationMessage", deprecationMessage)
    def getComment: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotfleetwise.model.Sensor
  ) extends zio.aws.iotfleetwise.model.Sensor.ReadOnly {
    override val fullyQualifiedName: String = impl.fullyQualifiedName(): String
    override val dataType: zio.aws.iotfleetwise.model.NodeDataType =
      zio.aws.iotfleetwise.model.NodeDataType.wrap(impl.dataType())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iotfleetwise.model.primitives.Description(value))
    override val unit: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.unit())
      .map(value => value: String)
    override val allowedValues: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.allowedValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val min: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.min())
      .map(value => value: Double)
    override val max: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: Double)
    override val deprecationMessage: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.deprecationMessage())
      .map(value => zio.aws.iotfleetwise.model.primitives.Message(value))
    override val comment: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => zio.aws.iotfleetwise.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotfleetwise.model.Sensor
  ): zio.aws.iotfleetwise.model.Sensor.ReadOnly = new Wrapper(impl)
}
