package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters.*
sealed trait SignalDecoderType {
  def unwrap
      : software.amazon.awssdk.services.iotfleetwise.model.SignalDecoderType
}
object SignalDecoderType {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.SignalDecoderType
  ): zio.aws.iotfleetwise.model.SignalDecoderType = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.SignalDecoderType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.SignalDecoderType.CAN_SIGNAL =>
      val r = CAN_SIGNAL
      r
    case software.amazon.awssdk.services.iotfleetwise.model.SignalDecoderType.OBD_SIGNAL =>
      val r = OBD_SIGNAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleetwise.model.SignalDecoderType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.SignalDecoderType =
      software.amazon.awssdk.services.iotfleetwise.model.SignalDecoderType.UNKNOWN_TO_SDK_VERSION
  }
  case object CAN_SIGNAL extends zio.aws.iotfleetwise.model.SignalDecoderType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.SignalDecoderType =
      software.amazon.awssdk.services.iotfleetwise.model.SignalDecoderType.CAN_SIGNAL
  }
  case object OBD_SIGNAL extends zio.aws.iotfleetwise.model.SignalDecoderType {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.SignalDecoderType =
      software.amazon.awssdk.services.iotfleetwise.model.SignalDecoderType.OBD_SIGNAL
  }
}
