package zio.aws.iotfleetwise.model
import scala.jdk.CollectionConverters.*
sealed trait StorageCompressionFormat {
  def unwrap: software.amazon.awssdk.services.iotfleetwise.model.StorageCompressionFormat
}
object StorageCompressionFormat {
  def wrap(
      value: software.amazon.awssdk.services.iotfleetwise.model.StorageCompressionFormat
  ): zio.aws.iotfleetwise.model.StorageCompressionFormat = value match {
    case software.amazon.awssdk.services.iotfleetwise.model.StorageCompressionFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotfleetwise.model.StorageCompressionFormat.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.iotfleetwise.model.StorageCompressionFormat.GZIP =>
      val r = GZIP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotfleetwise.model.StorageCompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.StorageCompressionFormat =
      software.amazon.awssdk.services.iotfleetwise.model.StorageCompressionFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.iotfleetwise.model.StorageCompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.StorageCompressionFormat =
      software.amazon.awssdk.services.iotfleetwise.model.StorageCompressionFormat.NONE
  }
  case object GZIP extends zio.aws.iotfleetwise.model.StorageCompressionFormat {
    override def unwrap
        : software.amazon.awssdk.services.iotfleetwise.model.StorageCompressionFormat =
      software.amazon.awssdk.services.iotfleetwise.model.StorageCompressionFormat.GZIP
  }
}
